/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.pvm.internal.id;

import java.util.ArrayList;
import org.hibernate.Session;
import org.jbpm.api.JbpmException;
import org.jbpm.api.cmd.Command;
import org.jbpm.api.cmd.Environment;
import org.jbpm.internal.log.Log;
import org.jbpm.pvm.internal.history.model.HistoryActivityInstanceImpl;
import org.jbpm.pvm.internal.history.model.HistoryDetailImpl;
import org.jbpm.pvm.internal.history.model.HistoryTaskImpl;
import org.jbpm.pvm.internal.history.model.HistoryVariableImpl;
import org.jbpm.pvm.internal.id.PropertyImpl;
import org.jbpm.pvm.internal.identity.impl.GroupImpl;
import org.jbpm.pvm.internal.identity.impl.MembershipImpl;
import org.jbpm.pvm.internal.identity.impl.UserImpl;
import org.jbpm.pvm.internal.job.JobImpl;
import org.jbpm.pvm.internal.lob.Lob;
import org.jbpm.pvm.internal.model.ExecutionImpl;
import org.jbpm.pvm.internal.repository.DeploymentImpl;
import org.jbpm.pvm.internal.repository.DeploymentProperty;
import org.jbpm.pvm.internal.task.ParticipationImpl;
import org.jbpm.pvm.internal.task.SwimlaneImpl;
import org.jbpm.pvm.internal.task.TaskImpl;
import org.jbpm.pvm.internal.type.Variable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InitializePropertiesCmd
implements Command<Long> {
    private static final long serialVersionUID = 1L;
    private static Log log = Log.getLog(InitializePropertiesCmd.class.getName());
    long blocksize;

    public InitializePropertiesCmd(long blocksize) {
        this.blocksize = blocksize;
    }

    @Override
    public Long execute(Environment environment) throws Exception {
        Session session = environment.get(Session.class);
        Long nextId = this.initializeNextId(session);
        this.initializeSchemaVersion(session);
        session.flush();
        return nextId;
    }

    void initializeSchemaVersion(Session session) {
        PropertyImpl property = (PropertyImpl)session.createQuery("select property from " + PropertyImpl.class.getName() + " as property " + "where property.key = '" + "db.version" + "'").uniqueResult();
        log.debug("version of jbpm library: 4.4-SNAPSHOT");
        if (property == null) {
            log.info("version of jbpm db schema: none");
        } else {
            String dbSchemaVersion = property.getValue();
            log.debug("version of jbpm db schema: " + dbSchemaVersion);
            if (!"4.4-SNAPSHOT".equals(dbSchemaVersion)) {
                throw new JbpmException("jBPM runtime version 4.4-SNAPSHOT doesn't match with DB schema, which is version ");
            }
        }
    }

    Long initializeNextId(Session session) {
        Long nextId;
        PropertyImpl property = (PropertyImpl)session.createQuery("select property from " + PropertyImpl.class.getName() + " as property " + "where property.key = '" + "next.dbid" + "'").uniqueResult();
        if (property == null) {
            Long l = nextId = this.getMaxDbid(session);
            Long l2 = nextId = Long.valueOf(nextId + 1L);
            property = new PropertyImpl("next.dbid", Long.toString(nextId + this.blocksize));
            session.save((Object)property);
        } else {
            String nextIdText = property.getValue();
            nextId = new Long(nextIdText);
            property.setValue(Long.toString(nextId + this.blocksize));
            session.update((Object)property);
        }
        return nextId;
    }

    private Long getMaxDbid(Session session) {
        Long nextId = 0L;
        ArrayList<String> persistedTypes = new ArrayList<String>();
        persistedTypes.add(DeploymentImpl.class.getName());
        persistedTypes.add(DeploymentProperty.class.getName());
        persistedTypes.add(ExecutionImpl.class.getName());
        persistedTypes.add(GroupImpl.class.getName());
        persistedTypes.add(HistoryActivityInstanceImpl.class.getName());
        persistedTypes.add(HistoryDetailImpl.class.getName());
        persistedTypes.add(HistoryTaskImpl.class.getName());
        persistedTypes.add(HistoryVariableImpl.class.getName());
        persistedTypes.add(JobImpl.class.getName());
        persistedTypes.add(Lob.class.getName());
        persistedTypes.add(MembershipImpl.class.getName());
        persistedTypes.add(ParticipationImpl.class.getName());
        persistedTypes.add(PropertyImpl.class.getName());
        persistedTypes.add(SwimlaneImpl.class.getName());
        persistedTypes.add(TaskImpl.class.getName());
        persistedTypes.add(UserImpl.class.getName());
        persistedTypes.add(Variable.class.getName());
        for (String persistedType : persistedTypes) {
            try {
                Long maxDbid = (Long)session.createQuery("select max(object.dbid) from " + persistedType + " as object").uniqueResult();
                if (maxDbid == null || maxDbid <= nextId) continue;
                nextId = (long)maxDbid;
            }
            catch (Exception e) {
                log.info("couldn't get max dbid for " + persistedType);
            }
        }
        return nextId;
    }
}

