/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.pvm.internal.query;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.hibernate.Query;
import org.hibernate.Session;
import org.jbpm.api.ProcessDefinition;
import org.jbpm.api.ProcessDefinitionQuery;
import org.jbpm.pvm.internal.env.EnvironmentImpl;
import org.jbpm.pvm.internal.model.ProcessDefinitionImpl;
import org.jbpm.pvm.internal.query.AbstractQuery;
import org.jbpm.pvm.internal.query.Page;
import org.jbpm.pvm.internal.repository.DeploymentImpl;
import org.jbpm.pvm.internal.repository.DeploymentProperty;
import org.jbpm.pvm.internal.session.RepositorySession;
import org.jbpm.pvm.internal.util.CollectionUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProcessDefinitionQueryImpl
extends AbstractQuery
implements ProcessDefinitionQuery {
    private static final long serialVersionUID = 1L;
    protected String id;
    protected String key;
    protected String nameLike;
    protected String name;
    protected Boolean suspended;
    protected String deploymentId;

    @Override
    public Object execute(Session session) {
        Object result = super.execute(session);
        RepositorySession repositorySession = EnvironmentImpl.getFromCurrent(RepositorySession.class);
        if (this.uniqueResult) {
            if (result == null) {
                return null;
            }
            return ProcessDefinitionQueryImpl.getProcessDefinition(repositorySession, result);
        }
        List propertyMaps = (List)result;
        if (propertyMaps.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<ProcessDefinitionImpl> processDefinitions = new ArrayList<ProcessDefinitionImpl>();
        for (Object propertyObject : propertyMaps) {
            ProcessDefinitionImpl processDefinition = ProcessDefinitionQueryImpl.getProcessDefinition(repositorySession, propertyObject);
            processDefinitions.add(processDefinition);
        }
        return processDefinitions;
    }

    private static ProcessDefinitionImpl getProcessDefinition(RepositorySession repositorySession, Object propertyObject) {
        Map propertyMap = (Map)propertyObject;
        String deploymentId = propertyMap.get("deploymentDbid").toString();
        String objectName = (String)propertyMap.get("objectName");
        return (ProcessDefinitionImpl)repositorySession.getObject(deploymentId, objectName);
    }

    @Override
    public String hql() {
        StringBuilder hql = new StringBuilder();
        hql.append("select new map( idProperty.objectName as objectName, idProperty.deployment.dbid as deploymentDbid ) ");
        hql.append("from ");
        hql.append(DeploymentImpl.class.getName());
        hql.append(" as deployment, ");
        hql.append(DeploymentProperty.class.getName());
        hql.append(" as idProperty, ");
        hql.append(DeploymentProperty.class.getName());
        hql.append(" as keyProperty, ");
        hql.append(DeploymentProperty.class.getName());
        hql.append(" as versionProperty ");
        if (this.suspended != null) {
            if (this.suspended.booleanValue()) {
                this.appendWhereClause("deployment.state = 'suspended'", hql);
            } else {
                this.appendWhereClause("deployment.state != 'suspended'", hql);
            }
        }
        this.appendWhereClause("idProperty.key = 'pdid'", hql);
        this.appendWhereClause("idProperty.deployment = deployment ", hql);
        this.appendWhereClause("keyProperty.key = 'pdkey' ", hql);
        this.appendWhereClause("keyProperty.objectName = idProperty.objectName ", hql);
        this.appendWhereClause("keyProperty.deployment = deployment ", hql);
        this.appendWhereClause("versionProperty.key = 'pdversion' ", hql);
        this.appendWhereClause("versionProperty.objectName = idProperty.objectName ", hql);
        this.appendWhereClause("versionProperty.deployment = deployment ", hql);
        if (this.id != null) {
            this.appendWhereClause("idProperty.stringValue = '" + this.id + "'", hql);
        }
        if (this.nameLike != null) {
            this.appendWhereClause("idProperty.objectName like '" + this.nameLike + "' ", hql);
        }
        if (this.name != null) {
            this.appendWhereClause("idProperty.objectName = '" + this.name + "' ", hql);
        }
        if (this.key != null) {
            this.appendWhereClause("keyProperty.stringValue = '" + this.key + "' ", hql);
        }
        if (this.deploymentId != null) {
            this.appendWhereClause("idProperty.deployment.dbid = " + this.deploymentId + " ", hql);
        }
        this.appendOrderByClause(hql);
        return hql.toString();
    }

    @Override
    protected void applyParameters(Query query) {
    }

    @Override
    public List<ProcessDefinition> list() {
        return CollectionUtil.checkList(this.untypedList(), ProcessDefinition.class);
    }

    @Override
    public ProcessDefinition uniqueResult() {
        return (ProcessDefinition)this.untypedUniqueResult();
    }

    @Override
    public long count() {
        return this.list().size();
    }

    @Override
    public ProcessDefinitionQuery processDefinitionId(String id) {
        this.id = id;
        return this;
    }

    @Override
    public ProcessDefinitionQuery processDefinitionKey(String key) {
        this.key = key;
        return this;
    }

    @Override
    public ProcessDefinitionQuery suspended() {
        this.suspended = true;
        return this;
    }

    @Override
    public ProcessDefinitionQuery notSuspended() {
        this.suspended = false;
        return this;
    }

    @Override
    public ProcessDefinitionQuery processDefinitionNameLike(String name) {
        this.nameLike = name;
        return this;
    }

    @Override
    public ProcessDefinitionQuery processDefinitionName(String name) {
        this.name = name;
        return this;
    }

    @Override
    public ProcessDefinitionQuery deploymentId(String deploymentId) {
        this.deploymentId = deploymentId;
        return this;
    }

    @Override
    public ProcessDefinitionQuery orderAsc(String property) {
        this.addOrderByClause(property + " asc");
        return this;
    }

    @Override
    public ProcessDefinitionQuery orderDesc(String property) {
        this.addOrderByClause(property + " desc");
        return this;
    }

    @Override
    public ProcessDefinitionQuery page(int firstResult, int maxResults) {
        this.page = new Page(firstResult, maxResults);
        return this;
    }
}

