/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.pvm.internal.svc;

import org.jbpm.api.cmd.Command;
import org.jbpm.api.cmd.Environment;
import org.jbpm.pvm.internal.cmd.CommandService;
import org.jbpm.pvm.internal.env.EnvironmentImpl;
import org.jbpm.pvm.internal.job.MessageImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AsyncCommandMessage
extends MessageImpl {
    private static final long serialVersionUID = 1L;
    private Command<?> command;
    private String userId;

    public AsyncCommandMessage(Command<?> command) {
        this.command = command;
    }

    public AsyncCommandMessage(Command<?> command, String userId) {
        this.command = command;
        this.userId = userId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void executeVoid(Environment environment) throws Exception {
        this.execution.setState("active-root");
        CommandService commandService = environment.get(CommandService.class);
        if (this.userId == null) {
            commandService.execute(this.command);
        } else {
            EnvironmentImpl environmentImpl = (EnvironmentImpl)environment;
            environmentImpl.setAuthenticatedUserId(this.userId);
            try {
                commandService.execute(this.command);
            }
            finally {
                environmentImpl.setAuthenticatedUserId(null);
            }
        }
    }

    public String toString() {
        return "AsyncCommandMessage[" + this.dbid + "]";
    }
}

