/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.context;

import java.io.IOException;
import java.io.InputStream;
import org.springframework.util.Assert;
import org.springframework.ws.WebServiceMessage;
import org.springframework.ws.WebServiceMessageFactory;
import org.springframework.ws.context.AbstractMessageContext;

public class DefaultMessageContext
extends AbstractMessageContext {
    private final WebServiceMessageFactory messageFactory;
    private final WebServiceMessage request;
    private WebServiceMessage response;

    public DefaultMessageContext(WebServiceMessageFactory messageFactory) {
        this((WebServiceMessage)messageFactory.createWebServiceMessage(), messageFactory);
    }

    public DefaultMessageContext(WebServiceMessage request, WebServiceMessageFactory messageFactory) {
        Assert.notNull((Object)request, (String)"request must not be null");
        Assert.notNull((Object)messageFactory, (String)"messageFactory must not be null");
        this.request = request;
        this.messageFactory = messageFactory;
    }

    public WebServiceMessage getRequest() {
        return this.request;
    }

    public boolean hasResponse() {
        return this.response != null;
    }

    public WebServiceMessage getResponse() {
        if (this.response == null) {
            this.response = this.messageFactory.createWebServiceMessage();
        }
        return this.response;
    }

    public void setResponse(WebServiceMessage response) {
        this.checkForResponse();
        this.response = response;
    }

    public void clearResponse() {
        this.response = null;
    }

    public void readResponse(InputStream inputStream) throws IOException {
        this.checkForResponse();
        this.response = this.messageFactory.createWebServiceMessage(inputStream);
    }

    public WebServiceMessageFactory getMessageFactory() {
        return this.messageFactory;
    }

    private void checkForResponse() throws IllegalStateException {
        if (this.response != null) {
            throw new IllegalStateException("Response message already created");
        }
    }
}

