/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.server.endpoint.adapter.method;

import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.MethodParameter;
import org.springframework.oxm.GenericMarshaller;
import org.springframework.oxm.GenericUnmarshaller;
import org.springframework.oxm.Marshaller;
import org.springframework.oxm.Unmarshaller;
import org.springframework.util.Assert;
import org.springframework.ws.WebServiceMessage;
import org.springframework.ws.context.MessageContext;
import org.springframework.ws.server.endpoint.adapter.method.AbstractPayloadMethodProcessor;
import org.springframework.ws.support.MarshallingUtils;

public class MarshallingPayloadMethodProcessor
extends AbstractPayloadMethodProcessor
implements InitializingBean {
    private Marshaller marshaller;
    private Unmarshaller unmarshaller;

    public MarshallingPayloadMethodProcessor() {
    }

    public MarshallingPayloadMethodProcessor(Marshaller marshaller) {
        Assert.notNull((Object)marshaller, (String)"marshaller must not be null");
        Assert.isInstanceOf(Unmarshaller.class, (Object)marshaller);
        this.setMarshaller(marshaller);
        this.setUnmarshaller((Unmarshaller)marshaller);
    }

    public MarshallingPayloadMethodProcessor(Marshaller marshaller, Unmarshaller unmarshaller) {
        Assert.notNull((Object)marshaller, (String)"marshaller must not be null");
        Assert.notNull((Object)unmarshaller, (String)"unmarshaller must not be null");
        this.setMarshaller(marshaller);
        this.setUnmarshaller(unmarshaller);
    }

    public Marshaller getMarshaller() {
        return this.marshaller;
    }

    public void setMarshaller(Marshaller marshaller) {
        this.marshaller = marshaller;
    }

    public Unmarshaller getUnmarshaller() {
        return this.unmarshaller;
    }

    public void setUnmarshaller(Unmarshaller unmarshaller) {
        this.unmarshaller = unmarshaller;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.marshaller, (String)"marshaller is required");
        Assert.notNull((Object)this.unmarshaller, (String)"unmarshaller is required");
    }

    protected boolean supportsRequestPayloadParameter(MethodParameter parameter) {
        if (this.unmarshaller instanceof GenericUnmarshaller) {
            return ((GenericUnmarshaller)this.unmarshaller).supports(parameter.getGenericParameterType());
        }
        return this.unmarshaller.supports(parameter.getParameterType());
    }

    public Object resolveArgument(MessageContext messageContext, MethodParameter parameter) throws Exception {
        WebServiceMessage request = messageContext.getRequest();
        Object argument = MarshallingUtils.unmarshal(this.getUnmarshaller(), request);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Unmarshalled payload request to [" + argument + "]"));
        }
        return argument;
    }

    protected boolean supportsResponsePayloadReturnType(MethodParameter returnType) {
        if (this.marshaller instanceof GenericMarshaller) {
            GenericMarshaller genericMarshaller = (GenericMarshaller)this.marshaller;
            return genericMarshaller.supports(returnType.getGenericParameterType());
        }
        return this.marshaller.supports(returnType.getParameterType());
    }

    public void handleReturnValue(MessageContext messageContext, MethodParameter returnType, Object returnValue) throws Exception {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Marshalling [" + returnValue + "] to response payload"));
        }
        WebServiceMessage response = messageContext.getResponse();
        MarshallingUtils.marshal(this.getMarshaller(), returnValue, response);
    }
}

