/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.server.endpoint.support;

import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import org.springframework.xml.namespace.QNameUtils;
import org.springframework.xml.transform.TraxUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public abstract class PayloadRootUtils {
    private PayloadRootUtils() {
    }

    public static QName getPayloadRootQName(Source source, TransformerFactory transformerFactory) throws TransformerException {
        XMLStreamReader streamReader;
        if (source == null) {
            return null;
        }
        if (source instanceof DOMSource) {
            DOMSource domSource = (DOMSource)source;
            Node node = domSource.getNode();
            if (node.getNodeType() == 1) {
                return QNameUtils.getQNameForNode((Node)node);
            }
            if (node.getNodeType() == 9) {
                Document document = (Document)node;
                return QNameUtils.getQNameForNode((Node)document.getDocumentElement());
            }
        } else if (TraxUtils.isStaxSource((Source)source) && (streamReader = TraxUtils.getXMLStreamReader((Source)source)) != null) {
            if (streamReader.getEventType() == 7) {
                try {
                    streamReader.nextTag();
                }
                catch (XMLStreamException ex) {
                    throw new IllegalStateException("Could not read next tag: " + ex.getMessage(), ex);
                }
            }
            if (streamReader.getEventType() == 1 || streamReader.getEventType() == 2) {
                return streamReader.getName();
            }
        }
        Transformer transformer = transformerFactory.newTransformer();
        DOMResult domResult = new DOMResult();
        transformer.transform(source, domResult);
        Document document = (Document)domResult.getNode();
        return QNameUtils.getQNameForNode((Node)document.getDocumentElement());
    }
}

