/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.soap.addressing.server;

import java.lang.reflect.Method;
import java.net.URI;
import org.springframework.aop.support.AopUtils;
import org.springframework.core.JdkVersion;
import org.springframework.util.Assert;
import org.springframework.ws.server.endpoint.MethodEndpoint;
import org.springframework.ws.soap.addressing.server.AbstractActionEndpointMapping;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractActionMethodEndpointMapping
extends AbstractActionEndpointMapping {
    protected void registerMethods(Object endpoint) {
        Method[] methods;
        Assert.notNull((Object)endpoint, (String)"'endpoint' must not be null");
        for (Method method : methods = AopUtils.getTargetClass((Object)endpoint).getMethods()) {
            URI action;
            if (JdkVersion.isAtLeastJava15() && method.isSynthetic() || method.getDeclaringClass().equals(Object.class) || (action = this.getActionForMethod(method)) == null) continue;
            this.registerEndpoint(action, new MethodEndpoint(endpoint, method));
        }
    }

    protected abstract URI getActionForMethod(Method var1);

    protected Class<?> getEndpointClass(Object endpoint) {
        return AopUtils.getTargetClass((Object)endpoint);
    }
}

