/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.transport;

import java.io.IOException;
import org.springframework.ws.WebServiceMessage;
import org.springframework.ws.WebServiceMessageFactory;
import org.springframework.ws.transport.TransportInputStream;
import org.springframework.ws.transport.TransportOutputStream;
import org.springframework.ws.transport.WebServiceConnection;

public abstract class AbstractWebServiceConnection
implements WebServiceConnection {
    private TransportInputStream tis;
    private TransportOutputStream tos;
    private boolean closed = false;

    public final void send(WebServiceMessage message) throws IOException {
        this.checkClosed();
        this.onSendBeforeWrite(message);
        this.tos = this.createTransportOutputStream();
        if (this.tos == null) {
            return;
        }
        message.writeTo(this.tos);
        this.tos.flush();
        this.onSendAfterWrite(message);
    }

    protected void onSendBeforeWrite(WebServiceMessage message) throws IOException {
    }

    protected abstract TransportOutputStream createTransportOutputStream() throws IOException;

    protected void onSendAfterWrite(WebServiceMessage message) throws IOException {
    }

    public final WebServiceMessage receive(WebServiceMessageFactory messageFactory) throws IOException {
        this.checkClosed();
        this.onReceiveBeforeRead();
        this.tis = this.createTransportInputStream();
        if (this.tis == null) {
            return null;
        }
        Object message = messageFactory.createWebServiceMessage(this.tis);
        this.onReceiveAfterRead((WebServiceMessage)message);
        return message;
    }

    protected void onReceiveBeforeRead() throws IOException {
    }

    protected abstract TransportInputStream createTransportInputStream() throws IOException;

    protected void onReceiveAfterRead(WebServiceMessage message) throws IOException {
    }

    public final void close() throws IOException {
        IOException ioex = null;
        if (this.tis != null) {
            try {
                this.tis.close();
            }
            catch (IOException ex) {
                ioex = ex;
            }
        }
        if (this.tos != null) {
            try {
                this.tos.close();
            }
            catch (IOException ex) {
                ioex = ex;
            }
        }
        this.onClose();
        this.closed = true;
        if (ioex != null) {
            throw ioex;
        }
    }

    private void checkClosed() {
        if (this.closed) {
            throw new IllegalStateException("Connection has been closed and cannot be reused.");
        }
    }

    protected void onClose() throws IOException {
    }
}

