/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.server.endpoint.adapter;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.MethodParameter;
import org.springframework.util.ClassUtils;
import org.springframework.util.CollectionUtils;
import org.springframework.ws.context.MessageContext;
import org.springframework.ws.server.endpoint.MethodEndpoint;
import org.springframework.ws.server.endpoint.adapter.AbstractMethodEndpointAdapter;
import org.springframework.ws.server.endpoint.adapter.method.MessageContextMethodArgumentResolver;
import org.springframework.ws.server.endpoint.adapter.method.MethodArgumentResolver;
import org.springframework.ws.server.endpoint.adapter.method.MethodReturnValueHandler;
import org.springframework.ws.server.endpoint.adapter.method.SourcePayloadMethodProcessor;
import org.springframework.ws.server.endpoint.adapter.method.StaxPayloadMethodArgumentResolver;
import org.springframework.ws.server.endpoint.adapter.method.XPathParamMethodArgumentResolver;
import org.springframework.ws.server.endpoint.adapter.method.dom.Dom4jPayloadMethodProcessor;
import org.springframework.ws.server.endpoint.adapter.method.dom.DomPayloadMethodProcessor;
import org.springframework.ws.server.endpoint.adapter.method.dom.JDomPayloadMethodProcessor;
import org.springframework.ws.server.endpoint.adapter.method.dom.XomPayloadMethodProcessor;
import org.springframework.ws.server.endpoint.adapter.method.jaxb.JaxbElementPayloadMethodProcessor;
import org.springframework.ws.server.endpoint.adapter.method.jaxb.XmlRootElementPayloadMethodProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultMethodEndpointAdapter
extends AbstractMethodEndpointAdapter
implements BeanClassLoaderAware,
InitializingBean {
    private static final String DOM4J_CLASS_NAME = "org.dom4j.Element";
    private static final String JAXB2_CLASS_NAME = "javax.xml.bind.Binder";
    private static final String JDOM_CLASS_NAME = "org.jdom.Element";
    private static final String STAX_CLASS_NAME = "javax.xml.stream.XMLInputFactory";
    private static final String XOM_CLASS_NAME = "nu.xom.Element";
    private static final String SOAP_METHOD_ARGUMENT_RESOLVER_CLASS_NAME = "org.springframework.ws.soap.server.endpoint.adapter.method.SoapMethodArgumentResolver";
    private List<MethodArgumentResolver> methodArgumentResolvers;
    private List<MethodReturnValueHandler> methodReturnValueHandlers;
    private ClassLoader classLoader;

    public List<MethodArgumentResolver> getMethodArgumentResolvers() {
        return this.methodArgumentResolvers;
    }

    public void setMethodArgumentResolvers(List<MethodArgumentResolver> methodArgumentResolvers) {
        this.methodArgumentResolvers = methodArgumentResolvers;
    }

    public List<MethodReturnValueHandler> getMethodReturnValueHandlers() {
        return this.methodReturnValueHandlers;
    }

    public void setMethodReturnValueHandlers(List<MethodReturnValueHandler> methodReturnValueHandlers) {
        this.methodReturnValueHandlers = methodReturnValueHandlers;
    }

    private ClassLoader getClassLoader() {
        return this.classLoader != null ? this.classLoader : DefaultMethodEndpointAdapter.class.getClassLoader();
    }

    public void setBeanClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public void afterPropertiesSet() throws Exception {
        this.initDefaultStrategies();
    }

    protected void initDefaultStrategies() {
        this.initMethodArgumentResolvers();
        this.initMethodReturnValueHandlers();
    }

    private void initMethodArgumentResolvers() {
        if (CollectionUtils.isEmpty(this.methodArgumentResolvers)) {
            ArrayList<MethodArgumentResolver> methodArgumentResolvers = new ArrayList<MethodArgumentResolver>();
            methodArgumentResolvers.add(new DomPayloadMethodProcessor());
            methodArgumentResolvers.add(new MessageContextMethodArgumentResolver());
            methodArgumentResolvers.add(new SourcePayloadMethodProcessor());
            methodArgumentResolvers.add(new XPathParamMethodArgumentResolver());
            try {
                Class soapMethodArgumentResolverClass = ClassUtils.forName((String)SOAP_METHOD_ARGUMENT_RESOLVER_CLASS_NAME, (ClassLoader)this.getClassLoader());
                methodArgumentResolvers.add((MethodArgumentResolver)BeanUtils.instantiate((Class)soapMethodArgumentResolverClass));
            }
            catch (ClassNotFoundException e) {
                this.logger.warn((Object)"Could not find \"org.springframework.ws.soap.server.endpoint.adapter.method.SoapMethodArgumentResolver\" on the classpath");
            }
            if (this.isPresent(DOM4J_CLASS_NAME)) {
                methodArgumentResolvers.add(new Dom4jPayloadMethodProcessor());
            }
            if (this.isPresent(JAXB2_CLASS_NAME)) {
                methodArgumentResolvers.add(new XmlRootElementPayloadMethodProcessor());
                methodArgumentResolvers.add(new JaxbElementPayloadMethodProcessor());
            }
            if (this.isPresent(JDOM_CLASS_NAME)) {
                methodArgumentResolvers.add(new JDomPayloadMethodProcessor());
            }
            if (this.isPresent(STAX_CLASS_NAME)) {
                methodArgumentResolvers.add(new StaxPayloadMethodArgumentResolver());
            }
            if (this.isPresent(XOM_CLASS_NAME)) {
                methodArgumentResolvers.add(new XomPayloadMethodProcessor());
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("No MethodArgumentResolvers set, using defaults: " + methodArgumentResolvers));
            }
            this.setMethodArgumentResolvers(methodArgumentResolvers);
        }
    }

    private void initMethodReturnValueHandlers() {
        if (CollectionUtils.isEmpty(this.methodReturnValueHandlers)) {
            ArrayList<MethodReturnValueHandler> methodReturnValueHandlers = new ArrayList<MethodReturnValueHandler>();
            methodReturnValueHandlers.add(new DomPayloadMethodProcessor());
            methodReturnValueHandlers.add(new SourcePayloadMethodProcessor());
            if (this.isPresent(DOM4J_CLASS_NAME)) {
                methodReturnValueHandlers.add(new Dom4jPayloadMethodProcessor());
            }
            if (this.isPresent(JAXB2_CLASS_NAME)) {
                methodReturnValueHandlers.add(new XmlRootElementPayloadMethodProcessor());
                methodReturnValueHandlers.add(new JaxbElementPayloadMethodProcessor());
            }
            if (this.isPresent(JDOM_CLASS_NAME)) {
                methodReturnValueHandlers.add(new JDomPayloadMethodProcessor());
            }
            if (this.isPresent(XOM_CLASS_NAME)) {
                this.methodArgumentResolvers.add(new XomPayloadMethodProcessor());
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("No MethodReturnValueHandlers set, using defaults: " + methodReturnValueHandlers));
            }
            this.setMethodReturnValueHandlers(methodReturnValueHandlers);
        }
    }

    private boolean isPresent(String className) {
        return ClassUtils.isPresent((String)className, (ClassLoader)this.getClassLoader());
    }

    @Override
    protected boolean supportsInternal(MethodEndpoint methodEndpoint) {
        return this.supportsParameters(methodEndpoint.getMethodParameters()) && this.supportsReturnType(methodEndpoint.getReturnType());
    }

    private boolean supportsParameters(MethodParameter[] methodParameters) {
        for (MethodParameter methodParameter : methodParameters) {
            boolean supported = false;
            for (MethodArgumentResolver methodArgumentResolver : this.methodArgumentResolvers) {
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace((Object)("Testing if argument resolver [" + methodArgumentResolver + "] supports [" + methodParameter.getGenericParameterType() + "]"));
                }
                if (!methodArgumentResolver.supportsParameter(methodParameter)) continue;
                supported = true;
                break;
            }
            if (supported) continue;
            return false;
        }
        return true;
    }

    private boolean supportsReturnType(MethodParameter methodReturnType) {
        if (Void.TYPE.equals(methodReturnType.getParameterType())) {
            return true;
        }
        for (MethodReturnValueHandler methodReturnValueHandler : this.methodReturnValueHandlers) {
            if (!methodReturnValueHandler.supportsReturnType(methodReturnType)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected final void invokeInternal(MessageContext messageContext, MethodEndpoint methodEndpoint) throws Exception {
        Class<?> returnType;
        Object[] args = this.getMethodArguments(messageContext, methodEndpoint);
        if (this.logger.isTraceEnabled()) {
            StringBuilder builder = new StringBuilder("Invoking [");
            builder.append(methodEndpoint).append("] with arguments ");
            builder.append(Arrays.asList(args));
            this.logger.trace((Object)builder.toString());
        }
        Object returnValue = methodEndpoint.invoke(args);
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("Method [" + methodEndpoint + "] returned [" + returnValue + "]"));
        }
        if (!Void.TYPE.equals(returnType = methodEndpoint.getMethod().getReturnType())) {
            this.handleMethodReturnValue(messageContext, returnValue, methodEndpoint);
        }
    }

    protected Object[] getMethodArguments(MessageContext messageContext, MethodEndpoint methodEndpoint) throws Exception {
        MethodParameter[] parameters = methodEndpoint.getMethodParameters();
        Object[] args = new Object[parameters.length];
        block0: for (int i = 0; i < parameters.length; ++i) {
            for (MethodArgumentResolver methodArgumentResolver : this.methodArgumentResolvers) {
                if (!methodArgumentResolver.supportsParameter(parameters[i])) continue;
                args[i] = methodArgumentResolver.resolveArgument(messageContext, parameters[i]);
                continue block0;
            }
        }
        return args;
    }

    protected void handleMethodReturnValue(MessageContext messageContext, Object returnValue, MethodEndpoint methodEndpoint) throws Exception {
        MethodParameter returnType = methodEndpoint.getReturnType();
        for (MethodReturnValueHandler methodReturnValueHandler : this.methodReturnValueHandlers) {
            if (!methodReturnValueHandler.supportsReturnType(returnType)) continue;
            methodReturnValueHandler.handleReturnValue(messageContext, returnType, returnValue);
            return;
        }
        throw new IllegalStateException("Return value [" + returnValue + "] not resolved by any MethodReturnValueHandler");
    }
}

