/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.server.endpoint.adapter.method;

import java.io.ByteArrayInputStream;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stax.StAXSource;
import javax.xml.transform.stream.StreamSource;
import org.springframework.core.MethodParameter;
import org.springframework.ws.server.endpoint.adapter.method.AbstractPayloadSourceMethodProcessor;
import org.springframework.xml.JaxpVersion;
import org.springframework.xml.transform.StaxSource;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public class SourcePayloadMethodProcessor
extends AbstractPayloadSourceMethodProcessor {
    private XMLInputFactory inputFactory = this.createXmlInputFactory();

    protected boolean supportsRequestPayloadParameter(MethodParameter parameter) {
        return this.supports(parameter);
    }

    protected Source resolveRequestPayloadArgument(MethodParameter parameter, Source requestPayload) throws Exception {
        Class parameterType = parameter.getParameterType();
        if (parameterType.isAssignableFrom(requestPayload.getClass())) {
            return requestPayload;
        }
        if (DOMSource.class.isAssignableFrom(parameterType)) {
            DOMResult domResult = new DOMResult();
            this.transform(requestPayload, domResult);
            Node node = domResult.getNode();
            if (node.getNodeType() == 9) {
                return new DOMSource(((Document)node).getDocumentElement());
            }
            return new DOMSource(domResult.getNode());
        }
        if (StaxSource.class.isAssignableFrom(parameterType)) {
            ByteArrayInputStream bis = this.convertToByteArrayInputStream(requestPayload);
            XMLStreamReader streamReader = this.inputFactory.createXMLStreamReader(bis);
            return new StaxSource(streamReader);
        }
        if (SAXSource.class.isAssignableFrom(parameterType)) {
            ByteArrayInputStream bis = this.convertToByteArrayInputStream(requestPayload);
            InputSource inputSource = new InputSource(bis);
            return new SAXSource(inputSource);
        }
        if (StreamSource.class.isAssignableFrom(parameterType)) {
            ByteArrayInputStream bis = this.convertToByteArrayInputStream(requestPayload);
            return new StreamSource(bis);
        }
        if (JaxpVersion.isAtLeastJaxp14() && Jaxp14StaxHandler.isStaxSource(parameterType)) {
            ByteArrayInputStream bis = this.convertToByteArrayInputStream(requestPayload);
            XMLStreamReader streamReader = this.inputFactory.createXMLStreamReader(bis);
            return Jaxp14StaxHandler.createStaxSource(streamReader);
        }
        throw new IllegalArgumentException("Unknown Source type: " + parameterType);
    }

    protected boolean supportsResponsePayloadReturnType(MethodParameter returnType) {
        return this.supports(returnType);
    }

    protected Source createResponsePayload(MethodParameter returnType, Object returnValue) {
        return (Source)returnValue;
    }

    private boolean supports(MethodParameter parameter) {
        return Source.class.isAssignableFrom(parameter.getParameterType());
    }

    protected XMLInputFactory createXmlInputFactory() {
        return XMLInputFactory.newInstance();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Jaxp14StaxHandler {
        private Jaxp14StaxHandler() {
        }

        private static boolean isStaxSource(Class<?> clazz) {
            return StAXSource.class.isAssignableFrom(clazz);
        }

        private static Source createStaxSource(XMLStreamReader streamReader) {
            return new StAXSource(streamReader);
        }
    }
}

