/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.server.endpoint.adapter.method.dom;

import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.DOMBuilder;
import org.jdom.transform.JDOMResult;
import org.jdom.transform.JDOMSource;
import org.springframework.core.MethodParameter;
import org.springframework.ws.server.endpoint.adapter.method.AbstractPayloadSourceMethodProcessor;
import org.w3c.dom.Node;

public class JDomPayloadMethodProcessor
extends AbstractPayloadSourceMethodProcessor {
    protected boolean supportsRequestPayloadParameter(MethodParameter parameter) {
        return this.supports(parameter);
    }

    protected Element resolveRequestPayloadArgument(MethodParameter parameter, Source requestPayload) throws Exception {
        if (requestPayload instanceof DOMSource) {
            Node node = ((DOMSource)requestPayload).getNode();
            DOMBuilder domBuilder = new DOMBuilder();
            if (node.getNodeType() == 1) {
                return domBuilder.build((org.w3c.dom.Element)node);
            }
            if (node.getNodeType() == 9) {
                Document document = domBuilder.build((org.w3c.dom.Document)node);
                return document.getRootElement();
            }
        }
        JDOMResult jdomResult = new JDOMResult();
        this.transform(requestPayload, (Result)jdomResult);
        return jdomResult.getDocument().getRootElement();
    }

    protected boolean supportsResponsePayloadReturnType(MethodParameter returnType) {
        return this.supports(returnType);
    }

    protected Source createResponsePayload(MethodParameter returnType, Object returnValue) {
        Element returnedElement = (Element)returnValue;
        return new JDOMSource(returnedElement);
    }

    private boolean supports(MethodParameter parameter) {
        return Element.class.equals((Object)parameter.getParameterType());
    }
}

