/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.soap.axiom;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMException;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.soap.RolePlayer;
import org.apache.axiom.soap.SOAPFactory;
import org.apache.axiom.soap.SOAPHeader;
import org.apache.axiom.soap.SOAPHeaderBlock;
import org.apache.axiom.soap.SOAPProcessingException;
import org.springframework.util.ObjectUtils;
import org.springframework.ws.soap.SoapHeaderElement;
import org.springframework.ws.soap.SoapHeaderException;
import org.springframework.ws.soap.axiom.AxiomSoapHeader;
import org.springframework.ws.soap.axiom.AxiomSoapHeaderElement;
import org.springframework.ws.soap.axiom.AxiomSoapHeaderException;
import org.springframework.ws.soap.soap12.Soap12Header;
import org.springframework.xml.namespace.QNameUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class AxiomSoap12Header
extends AxiomSoapHeader
implements Soap12Header {
    AxiomSoap12Header(SOAPHeader axiomHeader, SOAPFactory axiomFactory) {
        super(axiomHeader, axiomFactory);
    }

    @Override
    public SoapHeaderElement addNotUnderstoodHeaderElement(QName headerName) {
        try {
            SOAPHeaderBlock notUnderstood = this.getAxiomHeader().addHeaderBlock("NotUnderstood", this.getAxiomHeader().getNamespace());
            OMNamespace headerNamespace = notUnderstood.declareNamespace(headerName.getNamespaceURI(), QNameUtils.getPrefix((QName)headerName));
            notUnderstood.addAttribute("qname", headerNamespace.getPrefix() + ":" + headerName.getLocalPart(), null);
            return new AxiomSoapHeaderElement(notUnderstood, this.getAxiomFactory());
        }
        catch (SOAPProcessingException ex) {
            throw new AxiomSoapHeaderException(ex);
        }
    }

    @Override
    public SoapHeaderElement addUpgradeHeaderElement(String[] supportedSoapUris) {
        try {
            SOAPHeaderBlock upgrade = this.getAxiomHeader().addHeaderBlock("Upgrade", this.getAxiomHeader().getNamespace());
            for (String supportedSoapUri : supportedSoapUris) {
                OMElement supportedEnvelope = this.getAxiomFactory().createOMElement("SupportedEnvelope", this.getAxiomHeader().getNamespace(), (OMContainer)upgrade);
                OMNamespace namespace = supportedEnvelope.declareNamespace(supportedSoapUri, "");
                supportedEnvelope.addAttribute("qname", namespace.getPrefix() + ":Envelope", null);
            }
            return new AxiomSoapHeaderElement(upgrade, this.getAxiomFactory());
        }
        catch (OMException ex) {
            throw new AxiomSoapHeaderException(ex);
        }
    }

    @Override
    public Iterator<SoapHeaderElement> examineHeaderElementsToProcess(final String[] roles, final boolean isUltimateDestination) throws SoapHeaderException {
        RolePlayer rolePlayer = null;
        if (!ObjectUtils.isEmpty((Object[])roles)) {
            rolePlayer = new RolePlayer(){

                public List<?> getRoles() {
                    return Arrays.asList(roles);
                }

                public boolean isUltimateDestination() {
                    return isUltimateDestination;
                }
            };
        }
        Iterator result = this.getAxiomHeader().getHeadersToProcess(rolePlayer);
        return new AxiomSoapHeader.AxiomSoapHeaderElementIterator(this, result);
    }
}

