/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xml.stream;

import java.util.Iterator;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.springframework.util.StringUtils;
import org.springframework.xml.namespace.QNameUtils;
import org.springframework.xml.namespace.SimpleNamespaceContext;
import org.springframework.xml.stream.AbstractStaxContentHandler;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;

public class StaxStreamContentHandler
extends AbstractStaxContentHandler {
    private final XMLStreamWriter streamWriter;

    public StaxStreamContentHandler(XMLStreamWriter streamWriter) {
        this.streamWriter = streamWriter;
    }

    public void setDocumentLocator(Locator locator) {
    }

    protected void charactersInternal(char[] ch, int start, int length) throws XMLStreamException {
        this.streamWriter.writeCharacters(ch, start, length);
    }

    protected void endDocumentInternal() throws XMLStreamException {
        this.streamWriter.writeEndDocument();
    }

    protected void endElementInternal(QName name, SimpleNamespaceContext namespaceContext) throws XMLStreamException {
        this.streamWriter.writeEndElement();
    }

    protected void ignorableWhitespaceInternal(char[] ch, int start, int length) throws XMLStreamException {
        this.streamWriter.writeCharacters(ch, start, length);
    }

    protected void processingInstructionInternal(String target, String data) throws XMLStreamException {
        this.streamWriter.writeProcessingInstruction(target, data);
    }

    protected void skippedEntityInternal(String name) {
    }

    protected void startDocumentInternal() throws XMLStreamException {
        this.streamWriter.writeStartDocument();
    }

    protected void startElementInternal(QName name, Attributes attributes, SimpleNamespaceContext namespaceContext) throws XMLStreamException {
        this.streamWriter.writeStartElement(QNameUtils.getPrefix(name), name.getLocalPart(), name.getNamespaceURI());
        String defaultNamespaceUri = namespaceContext.getNamespaceURI("");
        if (StringUtils.hasLength((String)defaultNamespaceUri)) {
            this.streamWriter.writeNamespace("", defaultNamespaceUri);
            this.streamWriter.setDefaultNamespace(defaultNamespaceUri);
        }
        Iterator<String> iterator = namespaceContext.getBoundPrefixes();
        while (iterator.hasNext()) {
            String prefix = iterator.next();
            this.streamWriter.writeNamespace(prefix, namespaceContext.getNamespaceURI(prefix));
            this.streamWriter.setPrefix(prefix, namespaceContext.getNamespaceURI(prefix));
        }
        for (int i = 0; i < attributes.getLength(); ++i) {
            QName attrName = QNameUtils.toQName(attributes.getURI(i), attributes.getQName(i));
            String attrPrefix = QNameUtils.getPrefix(attrName);
            if ("xmlns".equals(attrName.getLocalPart()) || "xmlns".equals(attrPrefix)) continue;
            this.streamWriter.writeAttribute(attrPrefix, attrName.getNamespaceURI(), attrName.getLocalPart(), attributes.getValue(i));
        }
    }
}

