/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.reports.common.collection;

import com.crystaldecisions.reports.common.collection.CollectionBase;
import java.util.Collection;
import java.util.Map;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CollectionWithNameLookup<T>
extends CollectionBase<T> {
    protected Map<String, T> nameToObjectMap = new TreeMap<String, T>();
    protected boolean caseSensitive = false;
    protected boolean allowDuplicateNames = false;

    public CollectionWithNameLookup() {
        this(false, false);
    }

    public CollectionWithNameLookup(boolean bl, boolean bl2) {
        this.caseSensitive = bl;
        this.allowDuplicateNames = bl2;
    }

    protected abstract String getNameForObject(Object var1);

    @Override
    public Object clone() {
        CollectionWithNameLookup collectionWithNameLookup = (CollectionWithNameLookup)super.clone();
        collectionWithNameLookup.nameToObjectMap = new TreeMap<String, T>();
        collectionWithNameLookup.nameToObjectMap.putAll(this.nameToObjectMap);
        return collectionWithNameLookup;
    }

    @Override
    public boolean add(T t) {
        if (this.readOnly) {
            throw new UnsupportedOperationException("Cannot modify a read-only collection.");
        }
        return this.addObject(t);
    }

    @Override
    public boolean addObject(T t) {
        String string = this.getNameForObject(t);
        if (string == null) {
            return false;
        }
        string = string.trim();
        if (!this.caseSensitive) {
            string = string.toLowerCase();
        }
        if (!this.allowDuplicateNames && this.nameToObjectMap.containsKey(string)) {
            throw new UnsupportedOperationException("An object with the name '" + string + "' already exists in the collection.");
        }
        boolean bl = super.addObject(t);
        if (string != null && string.length() > 0) {
            this.nameToObjectMap.put(string, t);
        }
        return bl;
    }

    @Override
    public void clear() {
        super.clear();
        if (!this.nameToObjectMap.isEmpty()) {
            this.nameToObjectMap.clear();
        }
    }

    @Override
    public T get(String string) {
        String string2 = string.trim();
        if (!this.caseSensitive) {
            string2 = string2.toLowerCase();
        }
        return this.nameToObjectMap.get(string2);
    }

    @Override
    public T remove(int n) {
        Object e = this.get(n);
        if (!this.remove(e)) {
            return null;
        }
        return (T)e;
    }

    @Override
    public boolean remove(Object object) {
        if (!super.remove(object)) {
            return false;
        }
        String string = this.getNameForObject(object);
        string = string.trim();
        if (!this.caseSensitive) {
            string = string.toLowerCase();
        }
        this.nameToObjectMap.remove(string);
        return true;
    }

    @Override
    public T removeByName(String string) {
        T t = this.get(string);
        if (t == null) {
            return null;
        }
        if (!this.remove(t)) {
            return null;
        }
        return t;
    }

    @Override
    public boolean addAll(Collection<? extends T> collection) {
        if (this.readOnly) {
            throw new UnsupportedOperationException("Cannot modify a read-only collection.");
        }
        for (T t : collection) {
            if (this.addObject(t)) continue;
            return false;
        }
        return true;
    }
}

