/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.reports.common.value;

import com.crystaldecisions.reports.common.archive.ArchiveException;
import com.crystaldecisions.reports.common.archive.IInputArchive;
import com.crystaldecisions.reports.common.archive.IOutputArchive;
import com.crystaldecisions.reports.common.filemanagement.ExtendedDataOutput;
import com.crystaldecisions.reports.common.value.CrystalValue;
import com.crystaldecisions.reports.common.value.CurrencyValue;
import com.crystaldecisions.reports.common.value.FormulaValue;
import com.crystaldecisions.reports.common.value.NumberValue;
import com.crystaldecisions.reports.common.value.ValueType;
import java.io.DataInput;
import java.io.IOException;
import java.util.Comparator;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class BooleanValue
extends FormulaValue
implements Comparable {
    public static final BooleanValue FALSE = new BooleanValue(false);
    public static final BooleanValue TRUE = new BooleanValue(true);
    private final boolean void;

    private BooleanValue(boolean bl) {
        this.void = bl;
    }

    public static BooleanValue fromBoolean(boolean bl) {
        return bl ? TRUE : FALSE;
    }

    public boolean getBoolean() {
        return this.void;
    }

    public void store(ValueType valueType, ExtendedDataOutput extendedDataOutput) throws IOException {
        assert (valueType == this.getValueType());
        extendedDataOutput.writeBoolean(this.void);
    }

    public void storeToArchive(ValueType valueType, IOutputArchive iOutputArchive) throws ArchiveException {
        assert (valueType == this.getValueType());
        iOutputArchive.storeBoolean(this.void);
    }

    public static BooleanValue Load(DataInput dataInput) throws IOException {
        return BooleanValue.fromBoolean(dataInput.readBoolean());
    }

    public static BooleanValue LoadFromArchive(IInputArchive iInputArchive) throws ArchiveException {
        return BooleanValue.fromBoolean(iInputArchive.loadBoolean());
    }

    public static int GetMaxEncodedSize() {
        return 1;
    }

    public int getEncodedSizeForArchive(ValueType valueType) {
        assert (valueType == this.getValueType());
        return 2;
    }

    public int getEncodedSize(ValueType valueType) {
        assert (valueType == this.getValueType());
        return BooleanValue.GetMaxEncodedSize();
    }

    public ValueType getValueType() {
        return ValueType.bool;
    }

    public FormulaValue coerceToNumber() {
        return this.void ? NumberValue.one : NumberValue.zero;
    }

    public FormulaValue coerceToCurrency() {
        return this.void ? CurrencyValue.one : CurrencyValue.zero;
    }

    public FormulaValue coerceToBoolean() {
        return this;
    }

    public int hashCode(boolean bl) {
        return this.void ? 1231 : 1237;
    }

    public boolean equals(Object object, boolean bl) {
        if (object == null || object.getClass() != this.getClass()) {
            return false;
        }
        return this.compareTo(object) == 0;
    }

    public int compareTo(Object object, Comparator comparator) {
        return this.compareTo(object);
    }

    public int compareTo(Object object) {
        return BooleanValue.compare(this.void, ((BooleanValue)object).void);
    }

    public String toString() {
        return this.void ? "b(true)" : "b(false)";
    }

    public static boolean getAsBoolean(CrystalValue crystalValue, boolean bl) {
        if (crystalValue == null) {
            return bl;
        }
        if (crystalValue instanceof BooleanValue) {
            return ((BooleanValue)crystalValue).getBoolean();
        }
        throw new IllegalArgumentException();
    }
}

