/*
 * Decompiled with CFR 0.152.
 */
package com.usoftchina.smartschool.base;

import com.fasterxml.jackson.databind.JavaType;
import com.usoftchina.smartschool.exception.BaseException;
import com.usoftchina.smartschool.exception.BaseExceptionCode;
import com.usoftchina.smartschool.utils.JsonUtils;
import java.io.Serializable;

public class Result<T>
implements Serializable {
    private boolean success;
    private int code;
    private String message;
    private T data;

    public boolean isSuccess() {
        return this.success;
    }

    public void setSuccess(boolean success) {
        this.success = success;
    }

    public int getCode() {
        return this.code;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public T getData() {
        return this.data;
    }

    public void setData(T data) {
        this.data = data;
    }

    public static Result success() {
        Result result = new Result();
        result.setSuccess(true);
        return result;
    }

    public static <T> Result success(T data) {
        Result result = Result.success();
        result.setData(data);
        return result;
    }

    public static Result error() {
        Result result = new Result();
        result.setSuccess(false);
        return result;
    }

    public static Result error(String message) {
        Result result = Result.error();
        result.setMessage(message);
        return result;
    }

    public static Result error(Result from) {
        Result result = Result.error();
        result.setCode(from.getCode());
        result.setMessage(from.getMessage());
        return result;
    }

    public static Result error(int code, String message) {
        Result result = Result.error();
        result.setCode(code);
        result.setMessage(message);
        return result;
    }

    public static Result error(int code, String message, Object ... args) {
        Result result = Result.error();
        result.setCode(code);
        result.setMessage(String.format(message, args));
        return result;
    }

    public static Result throwable(Throwable e) {
        Result result = Result.error();
        if (e instanceof BaseException) {
            return Result.error((BaseException)((Object)e));
        }
        result.setCode(500);
        result.setMessage(e.getMessage());
        return result;
    }

    public static Result error(BaseException e) {
        Result result = Result.error();
        result.setCode(e.getCode());
        result.setMessage(e.getMessage());
        return result;
    }

    public static Result error(BaseExceptionCode e) {
        Result result = Result.error();
        result.setCode(e.getCode());
        result.setMessage(e.getMessage());
        return result;
    }

    public static <T> Result<T> fromJsonString(String jsonString, Class<T> targetClass) {
        return (Result)JsonUtils.fromJsonString(jsonString, Result.class, targetClass);
    }

    public static <T> Result<T> fromJsonString(String jsonString, JavaType targetType) {
        return (Result)JsonUtils.fromJsonString(jsonString, JsonUtils.getJavaType(Result.class, targetType));
    }
}

