/*
 * Decompiled with CFR 0.152.
 */
package com.usoftchina.smartschool.base.service;

import com.usoftchina.smartschool.base.entity.BaseEntity;
import com.usoftchina.smartschool.base.mapper.BaseMapper;
import com.usoftchina.smartschool.base.service.BaseService;
import com.usoftchina.smartschool.context.BaseContextHolder;
import java.io.Serializable;
import java.util.Date;
import java.util.List;

public abstract class BaseServiceImpl<ID extends Serializable, T extends BaseEntity<ID>>
implements BaseService<ID, T> {
    public abstract BaseMapper<ID, T> getMapper();

    @Override
    public boolean removeByPrimaryKey(ID id) {
        return this.getMapper().deleteByPrimaryKey(id) > 0;
    }

    @Override
    public boolean save(T record) {
        if (null != record) {
            this.setCreateInfo(record);
            ((BaseEntity)record).setCompanyId(BaseContextHolder.getCompanyId());
        }
        return this.getMapper().insert(record) > 0;
    }

    @Override
    public boolean saveSelective(T record) {
        if (null != record) {
            this.setCreateInfo(record);
            ((BaseEntity)record).setCompanyId(BaseContextHolder.getCompanyId());
        }
        return this.getMapper().insertSelective(record) > 0;
    }

    @Override
    public T findByPrimaryKey(ID id) {
        return this.getMapper().selectByPrimaryKey(id);
    }

    @Override
    public boolean updateByPrimaryKeySelective(T record) {
        if (null != record) {
            this.setUpdateInfo(record);
            ((BaseEntity)record).setCompanyId(BaseContextHolder.getCompanyId());
        }
        return this.getMapper().updateByPrimaryKeySelective(record) > 0;
    }

    @Override
    public boolean updateByPrimaryKey(T record) {
        if (null != record) {
            this.setUpdateInfo(record);
            ((BaseEntity)record).setCompanyId(BaseContextHolder.getCompanyId());
        }
        return this.getMapper().updateByPrimaryKey(record) > 0;
    }

    @Override
    public List<T> findAll() {
        return this.getMapper().selectAll();
    }

    @Override
    public List<T> findByCompanyId(long companyId) {
        return this.getMapper().selectByCompanyId(companyId);
    }

    private void setCreateInfo(T record) {
        Date nowDate = new Date();
        ((BaseEntity)record).setCreateTime(nowDate);
        ((BaseEntity)record).setCreatorId(BaseContextHolder.getUserId());
        ((BaseEntity)record).setUpdateTime(nowDate);
        ((BaseEntity)record).setUpdaterId(BaseContextHolder.getUserId());
    }

    private void setUpdateInfo(T record) {
        ((BaseEntity)record).setUpdateTime(new Date());
        ((BaseEntity)record).setUpdaterId(BaseContextHolder.getUserId());
    }
}

