/*
 * Decompiled with CFR 0.152.
 */
package com.usoftchina.smartschool.cache;

import com.usoftchina.smartschool.cache.Cache;
import com.usoftchina.smartschool.cache.CacheKeyHelper;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.springframework.data.redis.core.RedisTemplate;

public abstract class BaseRedisCache<K, V>
implements Cache<V> {
    private final Supplier<RedisTemplate<K, V>> redisTemplate;

    public BaseRedisCache(Supplier<RedisTemplate<K, V>> redisTemplate) {
        this.redisTemplate = redisTemplate;
    }

    protected abstract K key();

    public abstract Optional<V> getCache();

    protected RedisTemplate<K, V> getRedisTemplate() {
        return this.redisTemplate.get();
    }

    protected abstract Supplier<V> getSupplier();

    @Override
    public Optional<V> get() {
        return this.get(this.getSupplier());
    }

    @Override
    public boolean exists() {
        return this.getRedisTemplate().hasKey(this.key());
    }

    @Override
    public void clear() {
        this.getRedisTemplate().delete(this.key());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Optional<V> get(Supplier<V> supplier) {
        Optional<V> value = this.getCache();
        if (value.isPresent()) {
            return value;
        }
        Class<BaseRedisCache> clazz = BaseRedisCache.class;
        synchronized (BaseRedisCache.class) {
            value = this.getCache();
            if (value.isPresent()) {
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return value;
            }
            V obj = supplier.get();
            if (Objects.isNull(obj)) {
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return Optional.empty();
            }
            this.set(obj);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return Optional.of(obj);
        }
    }

    public Boolean expire(int timeout) {
        return this.getRedisTemplate().expire(this.key(), (long)timeout, TimeUnit.SECONDS);
    }

    protected String generatePrivateKey(CharSequence ... values) {
        return CacheKeyHelper.generatePrivateKey(values);
    }

    protected String generatePublicKey(CharSequence ... values) {
        return CacheKeyHelper.generatePublicKey(values);
    }
}

