/*
 * Decompiled with CFR 0.152.
 */
package com.usoftchina.smartschool.cache;

import com.usoftchina.smartschool.cache.BaseRedisCache;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import org.springframework.data.redis.core.BoundHashOperations;
import org.springframework.data.redis.core.RedisTemplate;

public abstract class RedisHashCache<K, F, V>
extends BaseRedisCache<K, V> {
    public RedisHashCache(Supplier<RedisTemplate<K, V>> redisTemplate) {
        super(redisTemplate);
    }

    protected abstract F field();

    protected BoundHashOperations<K, F, V> getBoundHashOperations() {
        return super.getRedisTemplate().boundHashOps(this.key());
    }

    public Set<F> keys() {
        return this.getBoundHashOperations().keys();
    }

    @Override
    public Optional<V> getCache() {
        Object value = this.getBoundHashOperations().get(this.field());
        if (value != null) {
            return Optional.of(value);
        }
        return Optional.empty();
    }

    @Override
    public void set(V value) {
        this.getBoundHashOperations().put(this.field(), value);
    }

    @Override
    public void set(V value, int seconds) {
        this.set(value);
    }

    @Override
    public boolean exists() {
        return this.getBoundHashOperations().hasKey(this.field());
    }

    @Override
    public void clear() {
        super.clear();
    }

    public void hdel() {
        this.getBoundHashOperations().delete(new Object[]{this.field()});
    }
}

