/*
 * Decompiled with CFR 0.152.
 */
package com.usoftchina.smartschool.context;

import com.alibaba.ttl.TransmittableThreadLocal;
import com.usoftchina.smartschool.utils.ObjectUtils;
import java.util.HashMap;
import java.util.Map;

public class BaseContextHolder {
    private static final ThreadLocal<Map<String, Object>> threadLocal = new TransmittableThreadLocal();

    public static void set(String key, Object value) {
        Map<String, Object> map = threadLocal.get();
        if (map == null) {
            map = new HashMap<String, Object>(1);
            threadLocal.set(map);
        }
        map.put(key, value);
    }

    public static Object get(String key) {
        Map<String, Object> map = threadLocal.get();
        if (map == null) {
            return null;
        }
        return map.get(key);
    }

    public static Long getUserId() {
        Object value = BaseContextHolder.get("currentUserId");
        return ObjectUtils.getLongValue(value);
    }

    public static void setUserId(long userId) {
        BaseContextHolder.set("currentUserId", userId);
    }

    public static Long getCompanyId() {
        Object value = BaseContextHolder.get("currentCompanyId");
        return ObjectUtils.getLongValue(value);
    }

    public static void setCompanyId(long companyId) {
        BaseContextHolder.set("currentCompanyId", companyId);
    }

    public static String getAppId() {
        Object value = BaseContextHolder.get("currentAppId");
        return ObjectUtils.getStringValue(value);
    }

    public static void setAppId(String appId) {
        BaseContextHolder.set("currentAppId", appId);
    }

    public static String getToken() {
        Object value = BaseContextHolder.get("currentToken");
        return ObjectUtils.getStringValue(value);
    }

    public static void setToken(String token) {
        BaseContextHolder.set("currentToken", token);
    }

    public static String getUserName() {
        Object value = BaseContextHolder.get("currentUserName");
        return ObjectUtils.getStringValue(value);
    }

    public static void setUserName(String userName) {
        BaseContextHolder.set("currentUserName", userName);
    }

    public static void remove() {
        threadLocal.remove();
    }
}

