/*
 * Decompiled with CFR 0.152.
 */
package com.usoftchina.smartschool.context;

import org.springframework.context.ApplicationContext;
import org.springframework.util.Assert;

public class SpringContextHolder {
    private static ApplicationContext context;

    public static void setContext(ApplicationContext context) {
        SpringContextHolder.context = context;
    }

    public static <T> T getBean(String name) {
        Assert.notNull((Object)context, (String)"spring context not ready");
        return (T)context.getBean(name);
    }

    public static <T> T getBean(Class<T> clazz) {
        Assert.notNull((Object)context, (String)"spring context not ready");
        return (T)context.getBean(clazz);
    }

    public static <T> T getBean(String name, Class<T> clazz) {
        Assert.notNull((Object)context, (String)"spring context not ready");
        return (T)context.getBean(name, clazz);
    }

    public static String getActiveProfile() {
        Assert.notNull((Object)context, (String)"spring context not ready");
        return context.getEnvironment().getActiveProfiles().length > 0 ? context.getEnvironment().getActiveProfiles()[0] : "local-dev";
    }

    public static String getApplicationName() {
        Assert.notNull((Object)context, (String)"spring context not ready");
        return context.getEnvironment().getProperty("spring.application.name");
    }
}

