/*
 * Decompiled with CFR 0.152.
 */
package com.usoftchina.smartschool.jdbc;

import com.usoftchina.smartschool.jdbc.Connectable;
import com.usoftchina.smartschool.jdbc.DynamicDataSource;
import com.usoftchina.smartschool.jdbc.JdbcUrl;
import com.zaxxer.hikari.HikariDataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.jdbc.DataSourceProperties;
import org.springframework.boot.jdbc.DataSourceBuilder;

public class DynamicDataSourceRegister {
    private DataSourceProperties defaultProperties;
    private final String defaultDatabaseName;
    private DynamicDataSource dynamicDataSource;
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    public DynamicDataSourceRegister(DataSourceProperties defaultProperties, DynamicDataSource dynamicDataSource) {
        this.defaultProperties = defaultProperties;
        this.defaultDatabaseName = JdbcUrl.getDatabaseName(defaultProperties.determineUrl());
        this.dynamicDataSource = dynamicDataSource;
    }

    public void createDataSource(Connectable connectable) {
        if (!this.dynamicDataSource.containsDataSource(connectable.qualifier())) {
            this.logger.info("connectable:" + connectable);
            HikariDataSource dataSource = (HikariDataSource)DataSourceBuilder.create((ClassLoader)this.defaultProperties.getClassLoader()).type(HikariDataSource.class).driverClassName(this.defaultProperties.determineDriverClassName()).url(connectable.url()).username(connectable.username()).password(connectable.password()).build();
            this.dynamicDataSource.addDataSource(connectable.qualifier(), dataSource);
        }
    }

    public void unregister(Connectable connectable) {
        this.dynamicDataSource.removeDataSource(connectable.qualifier());
    }

    public String getDefaultDatabaseName() {
        return this.defaultDatabaseName;
    }
}

