/*
 * Decompiled with CFR 0.152.
 */
package com.usoftchina.smartschool.jdbc;

import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JdbcUrl {
    public static String getDatabaseName(String url) {
        Matcher matcher;
        Type type = Type.fromJdbcUrl(url);
        Pattern pattern = type.getNamePattern();
        if (null != pattern && (matcher = pattern.matcher(url)).find()) {
            return matcher.group(1);
        }
        return null;
    }

    public static enum Type {
        MYSQL(".+\\/([^\\/]+)\\?.+"),
        POSTGRESQL(null),
        ORACLE(null),
        UNKNOWN(null);

        private Pattern namePattern;

        private Type(String nameRegexp) {
            if (null != nameRegexp) {
                this.namePattern = Pattern.compile(nameRegexp);
            }
        }

        protected String getUrlPrefix() {
            return this.name().toLowerCase(Locale.ENGLISH);
        }

        public static Type fromJdbcUrl(String url) {
            if (null != url) {
                String urlWithoutPrefix = url.substring("jdbc".length()).toLowerCase(Locale.ENGLISH);
                for (Type type : Type.values()) {
                    String prefix = ":" + type.getUrlPrefix() + ":";
                    if (type == UNKNOWN || !urlWithoutPrefix.startsWith(prefix)) continue;
                    return type;
                }
            }
            return UNKNOWN;
        }

        public Pattern getNamePattern() {
            return this.namePattern;
        }
    }
}

