/*
 * Decompiled with CFR 0.152.
 */
package com.usoftchina.smartschool.page;

import com.usoftchina.smartschool.exception.BizException;
import com.usoftchina.smartschool.exception.ExceptionCode;
import com.usoftchina.smartschool.page.PageDefault;
import com.usoftchina.smartschool.page.PageRequest;
import java.util.Optional;
import org.springframework.core.MethodParameter;
import org.springframework.lang.Nullable;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.support.WebDataBinderFactory;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.method.support.ModelAndViewContainer;

public class PageRequestArgumentResolver
implements HandlerMethodArgumentResolver {
    static final PageRequest DEFAULT_PAGE_REQUEST = PageRequest.of(1, 20);
    private PageRequest fallbackPageable = DEFAULT_PAGE_REQUEST;
    private static final int DEFAULT_MAX_PAGE_SIZE = 2000;
    private int maxPageSize = 2000;

    @Nullable
    public Object resolveArgument(MethodParameter parameter, @Nullable ModelAndViewContainer mavContainer, NativeWebRequest webRequest, @Nullable WebDataBinderFactory binderFactory) throws Exception {
        PageRequest defaultOrFallback = this.getDefaultFromAnnotationOrFallback(parameter);
        Optional<Integer> pageNumber = this.parseAndApplyBoundaries(webRequest.getParameter("number"), Integer.MAX_VALUE);
        Optional<Integer> pageSize = this.parseAndApplyBoundaries(webRequest.getParameter("size"), this.maxPageSize);
        int pn = pageNumber.orElseGet(defaultOrFallback::getNumber);
        int ps = pageSize.orElseGet(defaultOrFallback::getSize);
        return PageRequest.of(pn, ps);
    }

    public boolean supportsParameter(MethodParameter parameter) {
        return parameter.hasParameterAnnotation(PageDefault.class);
    }

    private PageRequest getDefaultFromAnnotationOrFallback(MethodParameter parameter) {
        PageDefault pageDefault = (PageDefault)parameter.getParameterAnnotation(PageDefault.class);
        if (pageDefault != null) {
            return PageRequestArgumentResolver.getDefaultPageRequestFrom(parameter, pageDefault);
        }
        return this.fallbackPageable;
    }

    private static PageRequest getDefaultPageRequestFrom(MethodParameter parameter, PageDefault pageDefault) {
        Integer defaultPageNumber = pageDefault.number();
        Integer defaultPageSize = pageDefault.size();
        if (defaultPageNumber < 1 || defaultPageSize < 1) {
            throw new BizException(ExceptionCode.INVALID_DEFAULT_PAGE);
        }
        return new PageRequest(defaultPageNumber, defaultPageSize);
    }

    private Optional<Integer> parseAndApplyBoundaries(@Nullable String parameter, int upper) {
        if (!StringUtils.hasText((String)parameter)) {
            return Optional.empty();
        }
        try {
            int parsed = Integer.parseInt(parameter);
            return Optional.of(parsed < 0 ? 0 : (parsed > upper ? upper : parsed));
        }
        catch (NumberFormatException e) {
            return Optional.of(0);
        }
    }

    public void setMaxPageSize(int maxPageSize) {
        this.maxPageSize = maxPageSize;
    }
}

