/*
 * Decompiled with CFR 0.152.
 */
package com.usoftchina.smartschool.utils;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.collect.Table;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;

public abstract class CollectionUtils
extends org.springframework.util.CollectionUtils {
    public static <K, V> Map<K, List<V>> groupBy(List<V> sources, Function<V, K> keyGetter) {
        HashMap map = new HashMap(1);
        if (!CollectionUtils.isEmpty(sources)) {
            sources.forEach(source -> {
                Object key = keyGetter.apply(source);
                if (map.containsKey(key)) {
                    ((List)map.get(key)).add(source);
                } else {
                    ArrayList<Object> childList = new ArrayList<Object>();
                    childList.add(source);
                    map.put(key, childList);
                }
            });
        }
        return map;
    }

    public static <R, C, V> Table<R, C, List<V>> groupBy(List<V> sources, Function<V, R> rKeyGetter, Function<V, C> cKeyGetter) {
        HashBasedTable table = HashBasedTable.create();
        if (!CollectionUtils.isEmpty(sources)) {
            sources.forEach(arg_0 -> CollectionUtils.lambda$groupBy$1(rKeyGetter, cKeyGetter, (Table)table, arg_0));
        }
        return table;
    }

    public static <R, C, V, S> Map<R, Map<C, List<V>>> groupBy(List<S> sources, Function<S, R> rKeyGetter, Function<S, C> cKeyGetter, Function<S, V> valueGetter) {
        HashMap table = new HashMap(1);
        if (!CollectionUtils.isEmpty(sources)) {
            sources.forEach(source -> {
                Object r = rKeyGetter.apply(source);
                Object c = cKeyGetter.apply(source);
                Object v = valueGetter.apply(source);
                if (table.containsKey(r)) {
                    Map rows = (Map)table.get(r);
                    if (rows.containsKey(c)) {
                        ((List)rows.get(c)).add(v);
                    } else {
                        rows.put(c, Lists.newArrayList((Object[])new Object[]{v}));
                    }
                } else {
                    HashMap rows = new HashMap(1);
                    rows.put(c, Lists.newArrayList((Object[])new Object[]{v}));
                    table.put(r, rows);
                }
            });
        }
        return table;
    }

    public static <R, C, V, S> Map<R, Map<C, Set<V>>> distinctBy(List<S> sources, Function<S, R> rKeyGetter, Function<S, C> cKeyGetter, Function<S, V> valueGetter) {
        HashMap table = new HashMap(1);
        if (!CollectionUtils.isEmpty(sources)) {
            sources.forEach(source -> {
                Object r = rKeyGetter.apply(source);
                Object c = cKeyGetter.apply(source);
                Object v = valueGetter.apply(source);
                if (table.containsKey(r)) {
                    Map rows = (Map)table.get(r);
                    if (rows.containsKey(c)) {
                        ((Set)rows.get(c)).add(v);
                    } else {
                        rows.put(c, Sets.newHashSet((Object[])new Object[]{v}));
                    }
                } else {
                    HashMap rows = new HashMap(1);
                    rows.put(c, Sets.newHashSet((Object[])new Object[]{v}));
                    table.put(r, rows);
                }
            });
        }
        return table;
    }

    private static /* synthetic */ void lambda$groupBy$1(Function rKeyGetter, Function cKeyGetter, Table table, Object source) {
        Object c;
        Object r = rKeyGetter.apply(source);
        if (table.contains(r, c = cKeyGetter.apply(source))) {
            ((List)table.get(r, c)).add(source);
        } else {
            ArrayList<Object> childList = new ArrayList<Object>();
            childList.add(source);
            table.put(r, c, childList);
        }
    }
}

