/*
 * Decompiled with CFR 0.152.
 */
package com.usoftchina.smartschool.utils;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;

public class DateUtils {
    static final SimpleDateFormat ym = new SimpleDateFormat("yyyyMM");
    static final SimpleDateFormat YM = new SimpleDateFormat("yyyy-MM");
    static final SimpleDateFormat YMD = new SimpleDateFormat("yyyy-MM-dd");
    static final SimpleDateFormat YMD_HMS = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    static final String YMD_STR = "yyyy-MM-dd";
    static final String ORACLE_YMD_HMS_STR = "yyyy-MM-dd HH24:mi:ss";
    static final String ORACLE_YMD_STR = "yyyy-MM-dd";
    static final String YMD_HMS_STR = "yyyy-MM-dd HH:mm:ss";

    public static String format(Date date, String f) {
        if (date == null) {
            date = new Date();
        }
        if (f == null) {
            return YMD.format(date);
        }
        SimpleDateFormat sdf = new SimpleDateFormat(f);
        return sdf.format(date);
    }

    public static Date parse(String date, String f) {
        if (date == null) {
            return new Date();
        }
        if (f == null) {
            try {
                return date.contains(" ") ? YMD_HMS.parse(date) : YMD.parse(date);
            }
            catch (ParseException e) {
                return new Date();
            }
        }
        SimpleDateFormat sdf = new SimpleDateFormat(f);
        try {
            return sdf.parse(date);
        }
        catch (ParseException e) {
            return new Date();
        }
    }

    public static int getYear(String date) throws ParseException {
        date = date == null ? DateUtils.format(null, null) : date;
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(YMD.parse(date));
        return calendar.get(1);
    }

    public static int getYear(Date date) throws ParseException {
        date = date == null ? DateUtils.parse(null, null) : date;
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar.get(1);
    }

    public static int getMonth(String date) throws ParseException {
        date = date == null ? DateUtils.format(null, null) : date;
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(YMD.parse(date));
        return calendar.get(2) + 1;
    }

    public static int getMonth(Date date) throws ParseException {
        date = date == null ? DateUtils.parse(null, null) : date;
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar.get(2) + 1;
    }

    public static int getDay(String date) throws ParseException {
        date = date == null ? DateUtils.format(null, null) : date;
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(YMD.parse(date));
        return calendar.get(5);
    }

    public static int getDay(Date date) throws ParseException {
        date = date == null ? DateUtils.parse(null, null) : date;
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar.get(5);
    }

    public static String getLastYearDay(String date) throws ParseException {
        date = date == null ? DateUtils.format(null, null) : date;
        Calendar calendar = Calendar.getInstance();
        try {
            calendar.setTime(YMD.parse(date));
        }
        catch (ParseException e) {
            calendar.setTime(new Date());
        }
        calendar.set(1, calendar.get(1) - 1);
        return YMD.format(calendar.getTime());
    }

    public static String getMinMonthDate(String date) {
        date = date == null ? DateUtils.format(null, null) : date;
        Calendar calendar = Calendar.getInstance();
        try {
            calendar.setTime(YMD.parse(date));
        }
        catch (ParseException e) {
            calendar.setTime(new Date());
        }
        calendar.set(5, calendar.getActualMinimum(5));
        return YMD.format(calendar.getTime());
    }

    public static String getMinMonthDate(Date date) {
        date = date == null ? DateUtils.parse(null, null) : date;
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(5, calendar.getActualMinimum(5));
        return YMD.format(calendar.getTime());
    }

    public static String getMaxMonthDate(String date) {
        date = date == null ? DateUtils.format(null, null) : date;
        Calendar calendar = Calendar.getInstance();
        try {
            calendar.setTime(YMD.parse(date));
        }
        catch (ParseException e) {
            calendar.setTime(new Date());
        }
        calendar.set(5, calendar.getActualMaximum(5));
        return YMD.format(calendar.getTime());
    }

    public static String getMaxMonthDate(Date date) {
        date = date == null ? DateUtils.parse(null, null) : date;
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(5, calendar.getActualMaximum(5));
        return YMD.format(calendar.getTime());
    }

    public static String getCurrentDate() {
        return DateUtils.format(new Date(), null);
    }

    public static String getCurrentDate(String format) {
        return DateUtils.format(new Date(), format);
    }

    public static Integer getYearmonth(Date date) {
        if (date == null) {
            date = new Date();
        }
        return Integer.parseInt(ym.format(date));
    }

    public static Integer getYearmonth(String date) {
        return Integer.parseInt(ym.format(DateUtils.parse(date, null)));
    }

    public static Integer getYearmonth() {
        return Integer.parseInt(ym.format(new Date()));
    }

    public static int compare(String date1, String date2) {
        try {
            Date dt1 = YMD.parse(date1);
            Date dt2 = YMD.parse(date2);
            if (dt1.getTime() > dt2.getTime()) {
                return 1;
            }
            if (dt1.getTime() < dt2.getTime()) {
                return -1;
            }
            return 0;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return 0;
        }
    }

    public static String getWeekDay(String DateStr) {
        SimpleDateFormat formatYMD = new SimpleDateFormat("yyyy-MM-dd");
        SimpleDateFormat formatD = new SimpleDateFormat("E");
        Date d = null;
        String weekDay = "";
        try {
            d = formatYMD.parse(DateStr);
            weekDay = formatD.format(d);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return weekDay;
    }

    public static int getWeekDay1(String DateStr) {
        SimpleDateFormat formatYMD = new SimpleDateFormat("yyyy-MM-dd");
        Date d = null;
        int weekDay = 0;
        try {
            d = formatYMD.parse(DateStr);
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(d);
            weekDay = calendar.get(7) - 1;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return weekDay;
    }

    public static List<Object> findDates(String start_time, String end_time) throws ParseException {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        Date date1 = df.parse(start_time);
        Date date2 = df.parse(end_time);
        int s = (int)((date2.getTime() - date1.getTime()) / 86400000L);
        ArrayList<Object> objects = new ArrayList<Object>();
        String value = "";
        if (s + 1 > 0) {
            for (int i = 0; i <= s; ++i) {
                long todayDate = date1.getTime() + (long)i * 24L * 60L * 60L * 1000L;
                Date tmDate = new Date(todayDate);
                value = new SimpleDateFormat("yyyy-MM-dd").format(tmDate);
                objects.add(value);
            }
        }
        return objects;
    }

    public static int countDates(String start_time, String end_time) throws ParseException {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        Date date1 = df.parse(start_time);
        Date date2 = df.parse(end_time);
        int s = (int)((date2.getTime() - date1.getTime()) / 86400000L);
        return s;
    }

    public static String parseDateToOracleString(String format, Date date) {
        if (format == null) {
            format = "yyyy-MM-dd";
        }
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        if (date == null) {
            date = new Date();
        }
        format = YMD_HMS_STR.toUpperCase().equals(format.toUpperCase()) ? ORACLE_YMD_HMS_STR : "yyyy-MM-dd";
        return "to_date('" + sdf.format(date) + "','" + format + "')";
    }

    public static int getMonthSpace(Date date1, Date date2) throws ParseException {
        int iMonth = 0;
        int flag = 0;
        try {
            Calendar objCalendarDate1 = Calendar.getInstance();
            objCalendarDate1.setTime(date1);
            Calendar objCalendarDate2 = Calendar.getInstance();
            objCalendarDate2.setTime(date2);
            if (objCalendarDate2.equals(objCalendarDate1)) {
                return 0;
            }
            if (objCalendarDate1.after(objCalendarDate2)) {
                Calendar temp = objCalendarDate1;
                objCalendarDate1 = objCalendarDate2;
                objCalendarDate2 = temp;
            }
            if (objCalendarDate2.get(5) > objCalendarDate1.get(5)) {
                flag = 1;
            }
            iMonth = objCalendarDate2.get(1) > objCalendarDate1.get(1) ? (objCalendarDate2.get(1) - objCalendarDate1.get(1)) * 12 + objCalendarDate2.get(2) + flag - objCalendarDate1.get(2) : objCalendarDate2.get(2) + flag - objCalendarDate1.get(2);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return iMonth;
    }

    public static Date overDate(Date date, int num) {
        date = date == null ? new Date() : date;
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(date);
        ((Calendar)calendar).add(5, num);
        date = calendar.getTime();
        return date;
    }

    public static Integer addMonth(Date date, int increase) {
        if (date == null) {
            date = new Date();
        }
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(date);
        ((Calendar)calendar).add(2, increase);
        return DateUtils.getYearmonth(calendar.getTime());
    }

    public static Integer addMonth(Integer month, int increase) {
        GregorianCalendar calendar = new GregorianCalendar();
        try {
            calendar.setTime(ym.parse(String.valueOf(month)));
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        ((Calendar)calendar).add(2, increase);
        return DateUtils.getYearmonth(calendar.getTime());
    }

    public static Date addHours(Date date, float hours) {
        Calendar ca = Calendar.getInstance();
        ca.setTime(date);
        ca.add(12, (int)(hours * 60.0f));
        return ca.getTime();
    }

    public static boolean isValidDate(String dateString, String f) {
        SimpleDateFormat sdf = new SimpleDateFormat(f);
        sdf.setLenient(false);
        try {
            sdf.parse(dateString);
        }
        catch (ParseException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public static Date string2Date(String dateStr, String format) throws Exception {
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        if (dateStr != null) {
            return sdf.parse(dateStr);
        }
        return null;
    }

    public static String date2String(Date date, String format) {
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        if (date != null) {
            return sdf.format(date);
        }
        return null;
    }

    public static Date getFirstDay(Date date) {
        String dates = DateUtils.date2String(date, "yyyy-MM");
        dates = dates + "-01";
        Date d = null;
        try {
            d = DateUtils.string2Date(dates, "yyyy-MM-dd");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return d;
    }

    public static int getYm(Date date) {
        String dates = DateUtils.date2String(date, "yyyyMM");
        int d = Integer.parseInt(dates);
        return d;
    }

    public static String plusDay(int num, String newDate) throws ParseException {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        Date currdate = format.parse(newDate);
        Calendar ca = Calendar.getInstance();
        ca.setTime(currdate);
        ca.add(5, num);
        Date next = ca.getTime();
        String enddate = format.format(next);
        return enddate;
    }
}

