/*
 * Decompiled with CFR 0.152.
 */
package com.usoftchina.smartschool.utils;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.usoftchina.smartschool.utils.StringUtils;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.List;
import java.util.TimeZone;

public class JsonUtils {
    private static ObjectMapper mapper = new ObjectMapper().setDateFormat((DateFormat)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss")).setTimeZone(TimeZone.getTimeZone("GMT+8"));

    public static String toJsonString(Object object) {
        try {
            return mapper.writeValueAsString(object);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static <T> T fromJsonString(String json, Class<T> targetCls) {
        if (StringUtils.isEmpty((Object)json)) {
            return null;
        }
        try {
            return (T)mapper.readValue(json, targetCls);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static JavaType getJavaType(Class<?> targetClass, Class<?> ... elementClasses) {
        return mapper.getTypeFactory().constructParametricType(targetClass, (Class[])elementClasses);
    }

    public static JavaType getJavaType(Class<?> targetClass, JavaType ... parameterTypes) {
        return mapper.getTypeFactory().constructParametricType(targetClass, parameterTypes);
    }

    public static <T> T fromJsonString(String json, Class<?> targetClass, Class<?> ... elementClasses) {
        if (StringUtils.isEmpty((Object)json)) {
            return null;
        }
        try {
            return (T)mapper.readValue(json, JsonUtils.getJavaType(targetClass, elementClasses));
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static <T> T fromJsonString(String json, JavaType type) {
        if (StringUtils.isEmpty((Object)json)) {
            return null;
        }
        try {
            return (T)mapper.readValue(json, type);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static <T> List<T> fromJsonArray(String json, Class<T> targetCls) {
        if (StringUtils.isEmpty((Object)json)) {
            return null;
        }
        try {
            if (!json.startsWith("[")) {
                json = "[" + json + "]";
            }
            return (List)mapper.readValue(json, JsonUtils.getJavaType(List.class, targetCls));
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

