/*
 * Decompiled with CFR 0.152.
 */
package com.usoftchina.smartschool.utils;

import com.usoftchina.smartschool.context.SpringContextHolder;
import com.usoftchina.smartschool.utils.CollectionUtils;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import org.springframework.data.redis.core.RedisTemplate;

public class RedisUtil {
    private static RedisTemplate<String, Object> redisTemplate = SpringContextHolder.getBean("redisTemplate", RedisTemplate.class);

    public static boolean expire(String key, long time) {
        try {
            if (time > 0L) {
                redisTemplate.expire((Object)key, time, TimeUnit.SECONDS);
            }
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static long getExpire(String key) {
        return redisTemplate.getExpire((Object)key, TimeUnit.SECONDS);
    }

    public static boolean hasKey(String key) {
        try {
            return redisTemplate.hasKey((Object)key);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static void del(String ... keys) {
        if (null != keys && keys.length > 0) {
            if (keys.length == 1) {
                redisTemplate.delete((Object)keys[0]);
            } else {
                redisTemplate.delete((Collection)CollectionUtils.arrayToList((Object)keys));
            }
        }
    }

    public static Object get(String key) {
        return key == null ? null : redisTemplate.opsForValue().get((Object)key);
    }

    public static boolean set(String key, Object obj) {
        try {
            redisTemplate.opsForValue().set((Object)key, obj);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean set(String key, Object value, long time) {
        try {
            if (time > 0L) {
                redisTemplate.opsForValue().set((Object)key, value, time, TimeUnit.SECONDS);
            } else {
                RedisUtil.set(key, value);
            }
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public long incr(String key, long delta) {
        if (delta < 0L) {
            throw new RuntimeException("\u9012\u589e\u56e0\u5b50\u5fc5\u987b\u5927\u4e8e0");
        }
        return redisTemplate.opsForValue().increment((Object)key, delta);
    }

    public long decr(String key, long delta) {
        if (delta < 0L) {
            throw new RuntimeException("\u9012\u51cf\u56e0\u5b50\u5fc5\u987b\u5927\u4e8e0");
        }
        return redisTemplate.opsForValue().increment((Object)key, -delta);
    }
}

