/*
 * Decompiled with CFR 0.152.
 */
package com.usoftchina.smartschool.utils;

import com.usoftchina.smartschool.utils.StringUtils;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RegexpUtils {
    private static final String CN_MOBILE_EXP = "^((13[0-9])|(15[0-3, 5-9])|(18[0,2,3,5-9])|(17[0-8])|(147))\\d{8}$";
    private static final String HK_MOBILE_EXP = "^(5|6|8|9)\\d{7}$";
    private static final String EMAIL_EXP = "^\\w+([-.]\\w+)*@\\w+([-]\\w+)*\\.(\\w+([-]\\w+)*\\.)*[a-z]{2,4}$";
    private static final String SPECCHARACTER_EXP = "[\\\\s~\u00b7`!\uff01@#\uffe5$%^\u2026\u2026&*\uff08()\uff09\\\\-\u2014\u2014\\\\-_=+\u3010\\\\[\\\\]\u3011\uff5b{}\uff5d\\\\|\u3001\\\\\\\\\uff1b;\uff1a:\u2018'\u201c\u201d\\\"\uff0c,\u300a<\u3002.\u300b>\u3001/\uff1f?]";
    private static final String SPECIALCHARACTER_EXP = "[`~!@#$%^&*()+=|{}':;',\\[\\]<>/?~\uff01@#\uffe5%\u2026\u2026&*\uff08\uff09\u2014\u2014+|{}\u3010\u3011\u2018\uff1b\uff1a\u201d\u201c\u2019\u3002\uff0c\u3001\uff1f\"]";
    private static final String NOTCODEFIELF_EXP = "[`@#$%^&*|{}':;',\\[\\]/?@#\uffe5%\u2026\u2026&*+|\u3010\u3011\u2018\uff1b\uff1a\u201d\u201c\u2019\u3002\uff0c\u3001\uff1f\"]";

    public static boolean isMobile(String str) {
        return RegexpUtils.isChinaMobile(str) || RegexpUtils.isHKMobile(str);
    }

    public static boolean isChinaMobile(String str) {
        Pattern p = Pattern.compile(CN_MOBILE_EXP);
        Matcher m = p.matcher(str);
        return m.matches();
    }

    public static boolean isHKMobile(String str) {
        Pattern p = Pattern.compile(HK_MOBILE_EXP);
        Matcher m = p.matcher(str);
        return m.matches();
    }

    public static boolean isEmail(String str) {
        Pattern p = Pattern.compile(EMAIL_EXP);
        Matcher m = p.matcher(str);
        return m.matches();
    }

    public static String replaceSpecCharacter(String str) {
        Pattern p = Pattern.compile(SPECCHARACTER_EXP);
        Matcher m = p.matcher(str);
        return m.replaceAll("");
    }

    public static String replaceSpecialCharacter(Object obj) {
        if (StringUtils.isEmpty((Object)obj)) {
            return "";
        }
        Pattern p = Pattern.compile(SPECIALCHARACTER_EXP);
        Matcher m = p.matcher(obj.toString().trim());
        return m.replaceAll("");
    }

    public static String replaceSpecialCharacterNotcodefield(Object obj) {
        if (StringUtils.isEmpty((Object)obj)) {
            return "";
        }
        Pattern p = Pattern.compile(NOTCODEFIELF_EXP);
        Matcher m = p.matcher(obj.toString().trim());
        return m.replaceAll("");
    }
}

