/*
 * Decompiled with CFR 0.152.
 */
package com.usoftchina.smartschool.utils.http;

import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import javax.crypto.KeyGenerator;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;

public class HmacEncoder {
    private final String algorithm;

    public HmacEncoder(String algorithm) {
        this.algorithm = algorithm;
    }

    public byte[] getKey() {
        KeyGenerator keyGenerator = null;
        try {
            keyGenerator = KeyGenerator.getInstance(this.algorithm);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e.getMessage());
        }
        SecretKey secretKey = keyGenerator.generateKey();
        return secretKey.getEncoded();
    }

    private static Key toKey(byte[] key, String algorithm) {
        return new SecretKeySpec(key, algorithm);
    }

    public byte[] encode(byte[] data, Key key) {
        Mac mac = null;
        try {
            mac = Mac.getInstance(this.algorithm);
            mac.init(key);
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            return new byte[0];
        }
        catch (InvalidKeyException e) {
            e.printStackTrace();
            return new byte[0];
        }
        return mac.doFinal(data);
    }

    public byte[] encode(byte[] data, byte[] key) {
        return this.encode(data, HmacEncoder.toKey(key, this.algorithm));
    }
}

