/*
 * Decompiled with CFR 0.152.
 */
package com.usoftchina.smartschool.utils.http;

import com.usoftchina.smartschool.utils.http.HmacUtils;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.message.BasicNameValuePair;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.RequestMethod;

public class HttpUtil {
    public static SSLContext createIgnoreVerifySSL() throws NoSuchAlgorithmException, KeyManagementException {
        SSLContext sc = SSLContext.getInstance("SSLv3");
        X509TrustManager trustManager = new X509TrustManager(){

            @Override
            public void checkClientTrusted(X509Certificate[] paramArrayOfX509Certificate, String paramString) throws CertificateException {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] paramArrayOfX509Certificate, String paramString) throws CertificateException {
            }

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }
        };
        sc.init(null, new TrustManager[]{trustManager}, null);
        return sc;
    }

    public static SSLContext createIgnoreVerifySSL2() throws NoSuchAlgorithmException, KeyManagementException {
        SSLContext sc = SSLContext.getInstance("SSL");
        X509TrustManager trustManager = new X509TrustManager(){

            @Override
            public void checkClientTrusted(X509Certificate[] paramArrayOfX509Certificate, String paramString) throws CertificateException {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] paramArrayOfX509Certificate, String paramString) throws CertificateException {
            }

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }
        };
        sc.init(null, new TrustManager[]{trustManager}, null);
        return sc;
    }

    public static Response sendGetRequest(String url, Map<String, String> params) throws Exception {
        return HttpUtil.sendGetRequest(url, params, false, null);
    }

    public static Response sendGetRequest(String url, Map<String, String> params, boolean sign, String signKey) throws Exception {
        return HttpUtil.sendRequest(RequestMethod.GET, url, params, sign, signKey);
    }

    public static Response sendGetRequest(String url, Map<String, String> params, boolean sign) throws Exception {
        return HttpUtil.sendRequest(RequestMethod.GET, url, params, sign, null);
    }

    public static Response sendPostRequest(String url, Map<String, String> params) throws Exception {
        return HttpUtil.sendPostRequest(url, params, false, null);
    }

    public static Response sendPostRequest(String url, List<?> datas) throws Exception {
        return HttpUtil.sendPostRequest(url, datas, false, null);
    }

    public static Response sendPostRequest(String url, Map<String, String> params, boolean sign, String signKey) throws Exception {
        return HttpUtil.sendRequest(RequestMethod.POST, url, params, sign, signKey);
    }

    public static Response sendPostRequest(String url, List<?> datas, boolean sign, String signKey) throws Exception {
        return HttpUtil.sendRequest(RequestMethod.POST, url, datas, sign, signKey);
    }

    public static Response sendPostRequest(String url, Map<String, String> params, boolean sign) throws Exception {
        return HttpUtil.sendRequest(RequestMethod.POST, url, params, sign, null);
    }

    public static Response sendPostRequest(String url, List<?> datas, boolean sign) throws Exception {
        return HttpUtil.sendRequest(RequestMethod.POST, url, datas, sign, null);
    }

    public static Response doPost(String postUrl, String formData, boolean sign, String signKey) throws Exception {
        SSLContext sslcontext = HttpUtil.createIgnoreVerifySSL();
        Registry socketFactoryRegistry = RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.INSTANCE).register("https", (Object)new SSLConnectionSocketFactory(sslcontext)).build();
        PoolingHttpClientConnectionManager connManager = new PoolingHttpClientConnectionManager(socketFactoryRegistry);
        HttpClients.custom().setConnectionManager((HttpClientConnectionManager)connManager);
        CloseableHttpClient httpClient = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)connManager).build();
        postUrl = HttpUtil.getUrl(postUrl, sign, signKey);
        HttpPost post = new HttpPost(postUrl);
        StringEntity postingString = new StringEntity(formData, "UTF-8");
        post.setEntity((HttpEntity)postingString);
        post.setHeader("Content-type", "application/json");
        CloseableHttpResponse response = httpClient.execute((HttpUriRequest)post);
        return Response.getResponse((HttpResponse)response);
    }

    public static Response doPostWithSSL(String postUrl, String formData, boolean sign, String signKey) throws Exception {
        SSLContext sslcontext = HttpUtil.createIgnoreVerifySSL2();
        Registry socketFactoryRegistry = RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.INSTANCE).register("https", (Object)new SSLConnectionSocketFactory(sslcontext)).build();
        PoolingHttpClientConnectionManager connManager = new PoolingHttpClientConnectionManager(socketFactoryRegistry);
        HttpClients.custom().setConnectionManager((HttpClientConnectionManager)connManager);
        CloseableHttpClient httpClient = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)connManager).build();
        postUrl = HttpUtil.getUrl(postUrl, sign, signKey);
        HttpPost post = new HttpPost(postUrl);
        StringEntity postingString = new StringEntity(formData, "UTF-8");
        post.setEntity((HttpEntity)postingString);
        post.setHeader("Content-type", "application/json");
        CloseableHttpResponse response = httpClient.execute((HttpUriRequest)post);
        return Response.getResponse((HttpResponse)response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Response doPost(String postUrl, String formData, boolean sign, String signKey, int timeout) throws Exception {
        URL url = new URL(postUrl);
        HttpURLConnection urlConn = (HttpURLConnection)url.openConnection();
        try {
            Object osw;
            urlConn.setDoOutput(true);
            urlConn.setDoInput(true);
            urlConn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded; charset=UTF-8");
            urlConn.setUseCaches(false);
            urlConn.setInstanceFollowRedirects(true);
            urlConn.setRequestMethod("POST");
            urlConn.setConnectTimeout(timeout);
            urlConn.setReadTimeout(timeout);
            if (null != formData) {
                osw = new OutputStreamWriter(urlConn.getOutputStream(), "UTF-8");
                ((Writer)osw).write(formData);
                ((OutputStreamWriter)osw).flush();
                ((OutputStreamWriter)osw).close();
            }
            osw = new Response(urlConn.getResponseCode() == 200, HttpUtil.streamToString(urlConn.getInputStream()));
            return osw;
        }
        catch (Exception e) {
            Response response = new Response(false, e.getMessage());
            return response;
        }
        finally {
            if (urlConn != null) {
                urlConn.disconnect();
            }
        }
    }

    public static String streamToString(InputStream in) throws Exception {
        BufferedReader reader = new BufferedReader(new InputStreamReader(in));
        StringBuilder buf = new StringBuilder();
        try {
            int len;
            char[] chars = new char[2048];
            while ((len = reader.read(chars, 0, chars.length)) >= 0) {
                buf.append(chars, 0, len);
            }
        }
        catch (Exception ex) {
            throw new Exception("read string from reader error", ex);
        }
        return buf.toString();
    }

    private static String getUrl(String url, boolean sign, String signKey) {
        StringBuilder buf = new StringBuilder(url);
        if (url.indexOf("?") == -1) {
            buf.append("?");
        } else if (!url.endsWith("&")) {
            buf.append("&");
        }
        if (sign) {
            buf.append("_timestamp=").append(System.currentTimeMillis());
            String message = buf.toString();
            buf.append("&_signature=").append(HmacUtils.encode(message, signKey));
        } else {
            buf.deleteCharAt(buf.length() - 1);
        }
        return buf.toString();
    }

    public static Response sendPutRequest(String url, List<?> datas, boolean sign) throws Exception {
        return HttpUtil.sendRequest(RequestMethod.PUT, url, datas, sign, null);
    }

    public static Response sendPutRequest(String url, Map<String, String> params, boolean sign) throws Exception {
        return HttpUtil.sendRequest(RequestMethod.PUT, url, params, sign, null);
    }

    public static Response sendPutRequest(String url, List<?> datas, boolean sign, String signKey) throws Exception {
        return HttpUtil.sendRequest(RequestMethod.PUT, url, datas, sign, signKey);
    }

    public static Response sendPutRequest(String url, List<?> datas) throws Exception {
        return HttpUtil.sendPutRequest(url, datas, false, null);
    }

    public static Response sendDeleteRequest(String url, Map<String, String> params) throws Exception {
        return HttpUtil.sendDeleteRequest(url, params, false, null);
    }

    public static Response sendDeleteRequest(String url, Map<String, String> params, boolean sign, String signKey) throws Exception {
        return HttpUtil.sendRequest(RequestMethod.DELETE, url, params, sign, signKey);
    }

    public static Response sendDeleteRequest(String url, Map<String, String> params, boolean sign) throws Exception {
        return HttpUtil.sendRequest(RequestMethod.DELETE, url, params, sign, null);
    }

    public static Response sendRequest(RequestMethod method, String url, Map<String, String> params, boolean sign, String signKey) throws Exception {
        switch (method) {
            case GET: {
                return HttpUtil.sendHttpUriRequest((HttpRequestBase)new HttpGet(HttpUtil.getRequestUrl(url, params, sign, signKey)));
            }
            case POST: {
                return HttpUtil.sendHttpEntityEnclosingRequest((HttpEntityEnclosingRequestBase)new HttpPost(HttpUtil.getRequestUrl(url, sign, signKey)), params);
            }
            case PUT: {
                return HttpUtil.sendHttpEntityEnclosingRequest((HttpEntityEnclosingRequestBase)new HttpPut(HttpUtil.getRequestUrl(url, sign, signKey)), params);
            }
            case DELETE: {
                return HttpUtil.sendHttpUriRequest((HttpRequestBase)new HttpDelete(HttpUtil.getRequestUrl(url, params, sign, signKey)));
            }
        }
        return HttpUtil.sendHttpUriRequest((HttpRequestBase)new HttpGet(HttpUtil.getRequestUrl(url, params, sign, signKey)));
    }

    public static Response sendRequest(RequestMethod method, String url, List<?> datas, boolean sign, String signKey) throws Exception {
        switch (method) {
            case POST: {
                return HttpUtil.sendHttpEntityEnclosingRequest((HttpEntityEnclosingRequestBase)new HttpPost(HttpUtil.getRequestUrl(url, sign, signKey)), datas);
            }
            case PUT: {
                return HttpUtil.sendHttpEntityEnclosingRequest((HttpEntityEnclosingRequestBase)new HttpPut(HttpUtil.getRequestUrl(url, sign, signKey)), datas);
            }
        }
        return HttpUtil.sendHttpEntityEnclosingRequest((HttpEntityEnclosingRequestBase)new HttpPost(HttpUtil.getRequestUrl(url, sign, signKey)), datas);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Response sendHttpUriRequest(HttpRequestBase request) throws Exception {
        SSLContext sslcontext = HttpUtil.createIgnoreVerifySSL();
        Registry socketFactoryRegistry = RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.INSTANCE).register("https", (Object)new SSLConnectionSocketFactory(sslcontext)).build();
        PoolingHttpClientConnectionManager connManager = new PoolingHttpClientConnectionManager(socketFactoryRegistry);
        HttpClients.custom().setConnectionManager((HttpClientConnectionManager)connManager);
        CloseableHttpClient httpClient = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)connManager).build();
        CloseableHttpResponse response = null;
        try {
            response = httpClient.execute((HttpUriRequest)request);
            Response response2 = Response.getResponse((HttpResponse)response);
            return response2;
        }
        finally {
            try {
                httpClient.close();
            }
            catch (IOException iOException) {}
            if (response != null) {
                try {
                    response.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Response sendHttpEntityEnclosingRequest(HttpEntityEnclosingRequestBase request, Map<String, String> params) throws Exception {
        SSLContext sslcontext = HttpUtil.createIgnoreVerifySSL();
        Registry socketFactoryRegistry = RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.INSTANCE).register("https", (Object)new SSLConnectionSocketFactory(sslcontext)).build();
        PoolingHttpClientConnectionManager connManager = new PoolingHttpClientConnectionManager(socketFactoryRegistry);
        HttpClients.custom().setConnectionManager((HttpClientConnectionManager)connManager);
        CloseableHttpClient httpClient = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)connManager).build();
        CloseableHttpResponse response = null;
        try {
            ArrayList<BasicNameValuePair> nvps = new ArrayList<BasicNameValuePair>();
            if (params != null && !params.isEmpty()) {
                Set<Map.Entry<String, String>> entrys = params.entrySet();
                for (Map.Entry<String, String> entry : entrys) {
                    nvps.add(new BasicNameValuePair(entry.getKey(), URLEncoder.encode(entry.getValue(), "UTF-8")));
                }
            }
            request.setEntity((HttpEntity)new UrlEncodedFormEntity(nvps));
            response = httpClient.execute((HttpUriRequest)request);
            System.out.println(request);
            Response response2 = Response.getResponse((HttpResponse)response);
            return response2;
        }
        finally {
            request.releaseConnection();
            try {
                httpClient.close();
            }
            catch (IOException iOException) {}
            if (response != null) {
                try {
                    response.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Response sendHttpEntityEnclosingRequest(HttpEntityEnclosingRequestBase request, List<?> datas) throws Exception {
        SSLContext sslcontext = HttpUtil.createIgnoreVerifySSL();
        Registry socketFactoryRegistry = RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.INSTANCE).register("https", (Object)new SSLConnectionSocketFactory(sslcontext)).build();
        PoolingHttpClientConnectionManager connManager = new PoolingHttpClientConnectionManager(socketFactoryRegistry);
        HttpClients.custom().setConnectionManager((HttpClientConnectionManager)connManager);
        CloseableHttpClient httpClient = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)connManager).build();
        CloseableHttpResponse response = null;
        try {
            if (datas == null || !datas.isEmpty()) {
                // empty if block
            }
            response = httpClient.execute((HttpUriRequest)request);
            Response response2 = Response.getResponse((HttpResponse)response);
            return response2;
        }
        finally {
            request.releaseConnection();
            try {
                httpClient.close();
            }
            catch (IOException iOException) {}
            if (response != null) {
                try {
                    response.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static String getRequestUrl(String url, Map<String, String> params, boolean sign) throws UnsupportedEncodingException {
        StringBuilder buf = new StringBuilder(url);
        if (url.indexOf("?") == -1) {
            buf.append("?");
        } else if (!url.endsWith("&")) {
            buf.append("&");
        }
        if (params != null && !params.isEmpty()) {
            Set<Map.Entry<String, String>> entrys = params.entrySet();
            for (Map.Entry<String, String> entry : entrys) {
                buf.append(entry.getKey()).append("=").append(URLEncoder.encode(entry.getValue(), "UTF-8")).append("&");
            }
        }
        if (sign) {
            buf.append("_timestamp=").append(System.currentTimeMillis());
            String message = buf.toString();
            buf.append("&_signature=").append(HmacUtils.encode(message));
        } else {
            buf.deleteCharAt(buf.length() - 1);
        }
        return buf.toString();
    }

    public static String getRequestUrl(String url, Map<String, String> params, boolean sign, String signKey) throws UnsupportedEncodingException {
        if (sign && signKey == null) {
            return HttpUtil.getRequestUrl(url, params, sign);
        }
        StringBuilder buf = new StringBuilder(url);
        if (url.indexOf("?") == -1) {
            buf.append("?");
        } else if (!url.endsWith("&")) {
            buf.append("&");
        }
        if (params != null && !params.isEmpty()) {
            Set<Map.Entry<String, String>> entrys = params.entrySet();
            for (Map.Entry<String, String> entry : entrys) {
                buf.append(entry.getKey()).append("=").append(URLEncoder.encode(entry.getValue(), "UTF-8")).append("&");
            }
        }
        if (sign) {
            buf.append("_timestamp=").append(System.currentTimeMillis());
            String message = buf.toString();
            buf.append("&_signature=").append(HmacUtils.encode(message, signKey));
        } else {
            buf.deleteCharAt(buf.length() - 1);
        }
        return buf.toString();
    }

    private static String getRequestUrl(String url, boolean sign, String signKey) throws UnsupportedEncodingException {
        return HttpUtil.getRequestUrl(url, null, sign, signKey);
    }

    public static byte[] read2Byte(InputStream inStream) throws Exception {
        ByteArrayOutputStream outSteam = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        int len = 0;
        while ((len = inStream.read(buffer)) != -1) {
            outSteam.write(buffer, 0, len);
        }
        outSteam.close();
        inStream.close();
        return outSteam.toByteArray();
    }

    public static String read2String(InputStream inStream) throws Exception {
        ByteArrayOutputStream outSteam = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        int len = 0;
        while ((len = inStream.read(buffer)) != -1) {
            outSteam.write(buffer, 0, len);
        }
        try {
            outSteam.close();
            inStream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new String(outSteam.toByteArray(), "UTF-8");
    }

    public static byte[] postXml(String path, String xml, String encoding) throws Exception {
        byte[] data = xml.getBytes(encoding);
        URL url = new URL(path);
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setRequestMethod("POST");
        conn.setDoOutput(true);
        conn.setRequestProperty("Content-Type", "text/xml; charset=" + encoding);
        conn.setRequestProperty("Content-Length", String.valueOf(data.length));
        conn.setConnectTimeout(5000);
        OutputStream outStream = conn.getOutputStream();
        outStream.write(data);
        outStream.flush();
        outStream.close();
        if (conn.getResponseCode() == HttpStatus.OK.value()) {
            return HttpUtil.read2Byte(conn.getInputStream());
        }
        return null;
    }

    public static InputStream download(String postUrl) throws ClientProtocolException, IOException, KeyManagementException, NoSuchAlgorithmException {
        SSLContext sslcontext = HttpUtil.createIgnoreVerifySSL();
        Registry socketFactoryRegistry = RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.INSTANCE).register("https", (Object)new SSLConnectionSocketFactory(sslcontext)).build();
        PoolingHttpClientConnectionManager connManager = new PoolingHttpClientConnectionManager(socketFactoryRegistry);
        HttpClients.custom().setConnectionManager((HttpClientConnectionManager)connManager);
        CloseableHttpClient httpClient = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)connManager).build();
        HttpGet httpGet = new HttpGet(postUrl);
        CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpGet);
        return response.getEntity().getContent();
    }

    public static class Response {
        private int statusCode;
        private String responseText;

        public int getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(int statusCode) {
            this.statusCode = statusCode;
        }

        public String getResponseText() {
            return this.responseText;
        }

        public void setResponseText(String responseText) {
            this.responseText = responseText;
        }

        public Response() {
        }

        public Response(boolean success, String content) {
            this.statusCode = success ? 200 : 404;
            this.responseText = content;
        }

        public Response(HttpResponse response) throws IllegalStateException, IOException, Exception {
            this.statusCode = response.getStatusLine().getStatusCode();
            this.responseText = HttpUtil.read2String(response.getEntity().getContent());
        }

        public static Response getResponse(HttpResponse response) throws IllegalStateException, IOException, Exception {
            if (response != null) {
                return new Response(response);
            }
            return null;
        }
    }
}

