/*
 * Decompiled with CFR 0.152.
 */
package nuonuo.open.sdk;

import java.security.cert.X509Certificate;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.http.HttpHost;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;

final class HttpConnPool {
    private static final int CONNECT_TIMEOUT = 5000;
    private static final int Max_PRE_ROUTE = 50;
    private static final int MAX_CONN = 100;
    private static final int MAX_ROUTE = 100;
    private static CloseableHttpClient httpClient;
    private static PoolingHttpClientConnectionManager manager;
    private static final Object syncLock;

    HttpConnPool() {
    }

    static void setRequestConfig(HttpRequestBase httpRequestBase, HttpHost proxy, int ... timeout) {
        int SOCKET_TIMEOUT = 30000;
        if (timeout != null && timeout.length == 1) {
            SOCKET_TIMEOUT = timeout[0] * 1000;
        }
        RequestConfig.Builder builder = RequestConfig.custom().setConnectionRequestTimeout(5000).setConnectTimeout(5000).setSocketTimeout(SOCKET_TIMEOUT);
        builder = proxy == null ? builder : builder.setProxy(proxy);
        httpRequestBase.setConfig(builder.build());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static CloseableHttpClient getHttpClient(String url) {
        if (httpClient == null) {
            Object object = syncLock;
            synchronized (object) {
                if (httpClient == null) {
                    String hostName = url.split("/")[2];
                    int port = 80;
                    if (hostName.contains(":")) {
                        String[] args = hostName.split(":");
                        hostName = args[0];
                        port = Integer.parseInt(args[1]);
                    }
                    httpClient = HttpConnPool.createHttpClient(hostName, port);
                    ScheduledExecutorService monitorExecutor = Executors.newScheduledThreadPool(1, new ThreadFactory(){

                        @Override
                        public Thread newThread(Runnable r) {
                            Thread t = Executors.defaultThreadFactory().newThread(r);
                            t.setDaemon(true);
                            return t;
                        }
                    });
                    int idleTimeout = 360000;
                    int initialDelay = 360000;
                    int period = 360000;
                    monitorExecutor.scheduleAtFixedRate(new Runnable(){

                        @Override
                        public void run() {
                            manager.closeExpiredConnections();
                            manager.closeIdleConnections(360000L, TimeUnit.MILLISECONDS);
                        }
                    }, initialDelay, period, TimeUnit.MILLISECONDS);
                }
            }
        }
        return httpClient;
    }

    private static CloseableHttpClient createHttpClient(String host, int port) {
        PlainConnectionSocketFactory plainsf = PlainConnectionSocketFactory.getSocketFactory();
        Registry registry = RegistryBuilder.create().register("https", (Object)new SSLConnectionSocketFactory(HttpConnPool.sslnoConfig())).register("http", (Object)plainsf).build();
        manager = new PoolingHttpClientConnectionManager(registry);
        manager.setMaxTotal(100);
        manager.setDefaultMaxPerRoute(50);
        HttpHost httpHost = new HttpHost(host, port);
        manager.setMaxPerRoute(new HttpRoute(httpHost), 100);
        return HttpClients.custom().setConnectionManager((HttpClientConnectionManager)manager).build();
    }

    private static SSLContext sslnoConfig() {
        final X509Certificate[] enpty = new X509Certificate[]{};
        SSLContext ctx = null;
        try {
            ctx = SSLContext.getInstance("TLS");
            X509TrustManager tm = new X509TrustManager(){

                @Override
                public void checkClientTrusted(X509Certificate[] chain, String authType) {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] chain, String authType) {
                }

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return enpty;
                }
            };
            ctx.init(null, new TrustManager[]{tm}, null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ctx;
    }

    static {
        syncLock = new Object();
    }
}

