/*
 * Decompiled with CFR 0.152.
 */
package nuonuo.open.sdk;

import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Set;
import nuonuo.open.sdk.HttpConnPool;
import nuonuo.open.sdk.NNException;
import org.apache.http.Consts;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.entity.StringEntity;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;

final class ModuleHttp {
    public static final String PROXY_HOST = "proxyHost";
    public static final String PROXY_PORT = "proxyPort";

    ModuleHttp() {
    }

    static String sendSyncHttp(String url, Map<String, String> header, String body, int ... timeout) throws IOException {
        HttpHost proxy = null;
        if (header.containsKey(PROXY_HOST) && header.containsKey(PROXY_PORT)) {
            proxy = new HttpHost(header.get(PROXY_HOST), Integer.parseInt(header.get(PROXY_PORT)), "http");
        }
        HttpPost httpPost = new HttpPost(url);
        HttpConnPool.setRequestConfig((HttpRequestBase)httpPost, proxy, timeout);
        ModuleHttp.setHeaders(httpPost, header);
        httpPost.setEntity((HttpEntity)new StringEntity(body, StandardCharsets.UTF_8.name()));
        CloseableHttpResponse response = HttpConnPool.getHttpClient(url).execute((HttpUriRequest)httpPost, (HttpContext)HttpClientContext.create());
        HttpEntity entity = response.getEntity();
        String result = null;
        int code = response.getStatusLine().getStatusCode();
        if (entity != null) {
            result = EntityUtils.toString((HttpEntity)entity, (Charset)Consts.UTF_8);
        }
        EntityUtils.consume((HttpEntity)entity);
        response.close();
        if (code != 200) {
            throw new NNException("\u53d1\u9001HTTP\u8bf7\u6c42\u5931\u8d25 code=" + code + " result=" + result);
        }
        return result;
    }

    private static void setHeaders(HttpPost httpPost, Map<String, String> header) {
        Set<String> keys = header.keySet();
        for (String key : keys) {
            httpPost.addHeader(key, header.get(key));
        }
    }
}

