/*
 * Decompiled with CFR 0.152.
 */
package com.kyexpress.openapi.sdk.builder.impl;

import com.kyexpress.openapi.sdk.builder.ApiBuilder;
import com.kyexpress.openapi.sdk.builder.AppBuilder;
import com.kyexpress.openapi.sdk.builder.ResponseBuilder;
import com.kyexpress.openapi.sdk.builder.impl.DefaultResponseBuilder;
import com.kyexpress.openapi.sdk.exception.KyeOpenApiException;
import com.kyexpress.openapi.sdk.utils.JsonUtils;
import com.kyexpress.openapi.sdk.utils.KyeOpenApiUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultApiBuilder
implements ApiBuilder {
    private String api;
    private Object body;
    private Map<String, String> headers = new HashMap<String, String>();
    private AppBuilder appBuilder;
    private int connectTimeout = 3000;
    private int readTimeout = 40000;
    private boolean sandbox = false;

    public DefaultApiBuilder(AppBuilder appBuilder, String api) {
        this.appBuilder = appBuilder;
        this.api = api;
    }

    @Override
    public ApiBuilder body(String body) {
        this.body = body;
        return this;
    }

    @Override
    public ApiBuilder body(List<Object> body) {
        this.body = body;
        return this;
    }

    @Override
    public ApiBuilder body(Map<String, Object> body) {
        this.body = body;
        return this;
    }

    @Override
    public ApiBuilder header(String header, String value) {
        this.headers.put(header, value);
        return this;
    }

    @Override
    public ApiBuilder sandbox(boolean sandbox) {
        this.sandbox = sandbox;
        return this;
    }

    @Override
    public ApiBuilder connectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
        return this;
    }

    @Override
    public ApiBuilder readTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
        return this;
    }

    @Override
    public ResponseBuilder request() throws KyeOpenApiException {
        return this.request(null);
    }

    @Override
    public ResponseBuilder request(Map<String, String> headers) throws KyeOpenApiException {
        if (headers != null) {
            this.headers.putAll(headers);
        }
        String responseContent = KyeOpenApiUtils.execOpenApiInvoke(this);
        boolean reRquest = false;
        try {
            String code;
            Map tmpResult = JsonUtils.serializable(responseContent, Map.class);
            if (tmpResult != null && tmpResult.get("code") != null && ((code = tmpResult.get("code").toString()).equals("6000") || code.equals("6001") || code.equals("6002") || code.equals("6003"))) {
                String tokenKey = this.appBuilder.getDomain() + this.appBuilder.getAppKey();
                KyeOpenApiUtils.removeToken(tokenKey);
                reRquest = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (reRquest) {
            responseContent = KyeOpenApiUtils.execOpenApiInvoke(this);
        }
        return new DefaultResponseBuilder(this.appBuilder.getAppKey(), this.getApiCode(), responseContent);
    }

    @Override
    public String getApiCode() {
        return this.api;
    }

    @Override
    public Object getBody() {
        return this.body;
    }

    @Override
    public Map<String, String> getHeaders() {
        return this.headers;
    }

    @Override
    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    @Override
    public int getReadTimeout() {
        return this.readTimeout;
    }

    @Override
    public AppBuilder getAppBuilder() {
        return this.appBuilder;
    }

    @Override
    public void setAppBuilder(AppBuilder appBuilder) {
        this.appBuilder = appBuilder;
    }

    @Override
    public boolean getSandbox() {
        return this.sandbox;
    }
}

