/*
 * Decompiled with CFR 0.152.
 */
package com.kyexpress.openapi.sdk.builder.impl;

import com.kyexpress.openapi.sdk.builder.ResponseBuilder;
import com.kyexpress.openapi.sdk.exception.KyeOpenApiException;
import com.kyexpress.openapi.sdk.utils.JsonUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultResponseBuilder
implements ResponseBuilder {
    private String appKey;
    private String api;
    private String responseContent;

    public DefaultResponseBuilder(String responseContent) {
        this.responseContent = responseContent;
    }

    public DefaultResponseBuilder(String appKey, String api, String responseContent) {
        this.appKey = appKey;
        this.api = api;
        this.responseContent = responseContent;
    }

    @Override
    public String response() {
        return this.responseContent;
    }

    @Override
    public <T> T response(Class<T> clazz) throws KyeOpenApiException {
        if (String.class == clazz) {
            return (T)this.responseContent;
        }
        try {
            return JsonUtils.serializable(this.responseContent, clazz);
        }
        catch (Exception e) {
            throw new KyeOpenApiException(this.appKey, this.api, "SERIALIZABLE_EXCEPTION", e);
        }
    }
}

