/*
 * Decompiled with CFR 0.152.
 */
package com.kyexpress.openapi.sdk.exception;

public class KyeOpenApiException
extends Exception {
    private String appKey;
    private String api;
    private String errCode;
    private String errMsg;

    public KyeOpenApiException() {
    }

    public KyeOpenApiException(String message, Throwable cause) {
        super(message, cause);
    }

    public KyeOpenApiException(String message) {
        super(message);
    }

    public KyeOpenApiException(Throwable cause) {
        super(cause);
    }

    public KyeOpenApiException(String errCode, String errMsg) {
        super(errCode + ":" + errMsg);
        this.errCode = errCode;
        this.errMsg = errMsg;
    }

    public KyeOpenApiException(String appKey, String api, Throwable cause) {
        super("[" + appKey + " " + api + "] " + cause.getMessage(), cause);
        this.appKey = appKey;
        this.api = api;
    }

    public KyeOpenApiException(String appKey, String api, String message, Throwable cause) {
        super("[" + appKey + " " + api + "] " + message, cause);
        this.appKey = appKey;
        this.api = api;
    }

    public KyeOpenApiException(String appKey, String api, String message) {
        super("[" + appKey + " " + api + "] " + message);
        this.appKey = appKey;
        this.api = api;
    }

    public String getAppKey() {
        return this.appKey;
    }

    public String getApi() {
        return this.api;
    }

    public String getErrCode() {
        return this.errCode;
    }

    public String getErrMsg() {
        return this.errMsg;
    }
}

