/*
 * Decompiled with CFR 0.152.
 */
package nuonuo.open.sdk;

import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import nuonuo.open.sdk.HttpConnPool;
import nuonuo.open.sdk.NNException;
import org.apache.http.Consts;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;

final class ModuleAuth {
    private static final String tokenUrl = "https://open.nuonuo.com/accessToken";

    ModuleAuth() {
    }

    static String getMerchantToken(String appKey, String appSecret, Map<String, String> header, String ... url) {
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("client_id", appKey);
        param.put("client_secret", appSecret);
        param.put("grant_type", "client_credentials");
        return ModuleAuth.doPost(url.length == 1 ? url[0] : tokenUrl, param, header);
    }

    static String getIsvToken(String code, String taxnum, String appKey, String appSecret, String redirectUri, Map<String, String> header, String ... url) {
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("client_id", appKey);
        param.put("client_secret", appSecret);
        param.put("grant_type", "authorization_code");
        param.put("redirect_uri", redirectUri);
        param.put("code", code);
        param.put("taxNum", taxnum);
        return ModuleAuth.doPost(url.length == 1 ? url[0] : tokenUrl, param, header);
    }

    static String refreshIsvToken(String refreshToken, String userId, String appSecret, Map<String, String> header, String ... url) {
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("refresh_token", refreshToken);
        param.put("client_id", userId);
        param.put("client_secret", appSecret);
        param.put("grant_type", "refresh_token");
        return ModuleAuth.doPost(url.length == 1 ? url[0] : tokenUrl, param, header);
    }

    private static String doPost(String url, Map<String, String> param, Map<String, String> header) {
        String result = null;
        HttpHost proxy = null;
        if (header != null && header.containsKey("proxyHost") && header.containsKey("proxyPort")) {
            proxy = new HttpHost(header.get("proxyHost"), Integer.parseInt(header.get("proxyPort")), "http");
        }
        HttpPost httpPost = new HttpPost(url);
        HttpConnPool.setRequestConfig((HttpRequestBase)httpPost, proxy, new int[0]);
        ArrayList<BasicNameValuePair> list = new ArrayList<BasicNameValuePair>();
        if (param != null && !param.isEmpty()) {
            for (Map.Entry<String, String> elem : param.entrySet()) {
                list.add(new BasicNameValuePair(elem.getKey(), elem.getValue()));
            }
        }
        httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(list, Consts.UTF_8));
        try {
            CloseableHttpResponse response = HttpClients.createDefault().execute((HttpUriRequest)httpPost, (HttpContext)HttpClientContext.create());
            HttpEntity entity = response.getEntity();
            if (entity != null) {
                result = EntityUtils.toString((HttpEntity)entity, (Charset)Consts.UTF_8);
            }
            response.close();
        }
        catch (IOException e) {
            throw new NNException("\u63a5\u53e3\u8c03\u7528\u5f02\u5e38\u3010url=" + url + "\u3011", e);
        }
        return result;
    }
}

