/*
 * Decompiled with CFR 0.152.
 */
package nuonuo.open.sdk;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;
import nuonuo.open.sdk.ModuleAuth;
import nuonuo.open.sdk.ModuleHttp;
import nuonuo.open.sdk.ModuleSign;
import nuonuo.open.sdk.NNException;

public class NNOpenSDK {
    private static final NNOpenSDK INSTANCE = new NNOpenSDK();

    public static final NNOpenSDK getIntance() {
        return INSTANCE;
    }

    private NNOpenSDK() {
    }

    public String getMerchantToken(String appKey, String appSecret, String ... url) {
        this.verify(appKey, "AppKey\u4e0d\u80fd\u4e3a\u7a7a");
        this.verify(appSecret, "AppSecret\u4e0d\u80fd\u4e3a\u7a7a");
        return ModuleAuth.getMerchantToken(appKey, appSecret, null, url);
    }

    public String getMerchantToken(String appKey, String appSecret, Map<String, String> header, String ... url) {
        this.verify(appKey, "AppKey\u4e0d\u80fd\u4e3a\u7a7a");
        this.verify(appSecret, "AppSecret\u4e0d\u80fd\u4e3a\u7a7a");
        return ModuleAuth.getMerchantToken(appKey, appSecret, header, url);
    }

    public String getISVToken(String appKey, String appSecret, String code, String taxnum, String redirectUri, String ... url) {
        this.verify(code, "code\u4e0d\u80fd\u4e3a\u7a7a");
        this.verify(taxnum, "taxnum\u4e0d\u80fd\u4e3a\u7a7a");
        this.verify(appKey, "AppKey\u4e0d\u80fd\u4e3a\u7a7a");
        this.verify(appSecret, "AppSecret\u4e0d\u80fd\u4e3a\u7a7a");
        this.verify(redirectUri, "redirectUri\u4e0d\u80fd\u4e3a\u7a7a");
        return ModuleAuth.getIsvToken(code, taxnum, appKey, appSecret, redirectUri, null, url);
    }

    public String getISVToken(String appKey, String appSecret, String code, String taxnum, String redirectUri, Map<String, String> header, String ... url) {
        this.verify(code, "code\u4e0d\u80fd\u4e3a\u7a7a");
        this.verify(taxnum, "taxnum\u4e0d\u80fd\u4e3a\u7a7a");
        this.verify(appKey, "AppKey\u4e0d\u80fd\u4e3a\u7a7a");
        this.verify(appSecret, "AppSecret\u4e0d\u80fd\u4e3a\u7a7a");
        this.verify(redirectUri, "redirectUri\u4e0d\u80fd\u4e3a\u7a7a");
        return ModuleAuth.getIsvToken(code, taxnum, appKey, appSecret, redirectUri, header, url);
    }

    public String refreshISVToken(String refreshToken, String userId, String appSecret, String ... url) {
        this.verify(userId, "userId\u4e0d\u80fd\u4e3a\u7a7a");
        this.verify(appSecret, "appSecret\u4e0d\u80fd\u4e3a\u7a7a");
        this.verify(refreshToken, "refreshToken\u4e0d\u80fd\u4e3a\u7a7a");
        return ModuleAuth.refreshIsvToken(refreshToken, userId, appSecret, null, url);
    }

    public String refreshISVToken(String refreshToken, String userId, String appSecret, Map<String, String> header, String ... url) {
        this.verify(userId, "userId\u4e0d\u80fd\u4e3a\u7a7a");
        this.verify(appSecret, "appSecret\u4e0d\u80fd\u4e3a\u7a7a");
        this.verify(refreshToken, "refreshToken\u4e0d\u80fd\u4e3a\u7a7a");
        return ModuleAuth.refreshIsvToken(refreshToken, userId, appSecret, header, url);
    }

    public String sendPostSyncRequest(String url, String senid, String appKey, String appSecret, String token, String taxnum, String method, String content, int ... timeout) {
        this.verify(senid, "senid\u4e0d\u80fd\u4e3a\u7a7a");
        this.verify(appKey, "appKey\u4e0d\u80fd\u4e3a\u7a7a");
        this.verify(method, "method\u4e0d\u80fd\u4e3a\u7a7a");
        this.verify(url, "\u8bf7\u6c42\u5730\u5740URL\u4e0d\u80fd\u4e3a\u7a7a");
        this.verify(content, "content\u4e0d\u80fd\u4e3a\u7a7a");
        this.verify(appSecret, "appSecret\u4e0d\u80fd\u4e3a\u7a7a");
        try {
            long timestamp = System.currentTimeMillis() / 1000L;
            String nonce = String.valueOf(ThreadLocalRandom.current().nextInt(10000, 1000000000));
            StringBuffer sb = new StringBuffer(url);
            sb.append("?senid=").append(senid).append("&nonce=").append(nonce).append("&timestamp=").append(timestamp).append("&appkey=").append(appKey);
            Map<String, String> header = this.buildHeader(url, senid, appKey, appSecret, token, taxnum, method, content, nonce, String.valueOf(timestamp), null);
            return ModuleHttp.sendSyncHttp(sb.toString(), header, content, timeout);
        }
        catch (IOException e) {
            throw new NNException("\u53d1\u9001HTTP\u8bf7\u6c42\u5f02\u5e38", e);
        }
    }

    public String sendPostSyncRequest(String url, String senid, String appKey, String appSecret, String token, String taxnum, String method, String content, Map<String, String> header, int ... timeout) {
        this.verify(senid, "senid\u4e0d\u80fd\u4e3a\u7a7a");
        this.verify(appKey, "appKey\u4e0d\u80fd\u4e3a\u7a7a");
        this.verify(method, "method\u4e0d\u80fd\u4e3a\u7a7a");
        this.verify(url, "\u8bf7\u6c42\u5730\u5740URL\u4e0d\u80fd\u4e3a\u7a7a");
        this.verify(content, "content\u4e0d\u80fd\u4e3a\u7a7a");
        this.verify(appSecret, "appSecret\u4e0d\u80fd\u4e3a\u7a7a");
        try {
            long timestamp = System.currentTimeMillis() / 1000L;
            String nonce = String.valueOf(ThreadLocalRandom.current().nextInt(10000, 1000000000));
            StringBuffer sb = new StringBuffer(url);
            sb.append("?senid=").append(senid).append("&nonce=").append(nonce).append("&timestamp=").append(timestamp).append("&appkey=").append(appKey);
            header = this.buildHeader(url, senid, appKey, appSecret, token, taxnum, method, content, nonce, String.valueOf(timestamp), header);
            return ModuleHttp.sendSyncHttp(sb.toString(), header, content, timeout);
        }
        catch (IOException e) {
            throw new NNException("\u53d1\u9001HTTP\u8bf7\u6c42\u5f02\u5e38", e);
        }
    }

    public String convertToUtf8(String gbk) {
        try {
            byte[] gbkArr = gbk.getBytes("gbk");
            byte[] utf8Arr = new String(gbkArr, "gbk").getBytes("utf-8");
            return new String(utf8Arr, "utf-8");
        }
        catch (Exception e) {
            throw new NNException("\u5b57\u7b26\u7f16\u7801\u8f6c\u6362\u5f02\u5e38", e);
        }
    }

    private void verify(String v, String msg) {
        if (v == null || v.trim().length() == 0 || v.toLowerCase().trim().equals("null")) {
            throw new NNException(msg);
        }
    }

    private Map<String, String> buildHeader(String url, String senid, String appKey, String appSecret, String token, String taxnum, String method, String content, String nonce, String timestamp, Map<String, String> header) throws MalformedURLException {
        URL httpUrl = new URL(url);
        String path = httpUrl.getPath();
        if (header == null || header.isEmpty()) {
            header = new HashMap<String, String>();
        }
        header.put("Content-Type", "application/json");
        header.put("X-Nuonuo-Sign", ModuleSign.getSign(path, appSecret, appKey, senid, nonce, content, timestamp));
        header.put("accessToken", token);
        header.put("userTax", taxnum);
        header.put("method", method);
        header.put("sdkVer", "1.0.5.2");
        return header;
    }
}

