/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.util.ArrayList;
import java.util.HashMap;
import oracle.jdbc.driver.NTFJMSConnection;
import oracle.jdbc.driver.PhysicalConnection;

public class NTFJMSPerDatabaseManager {
    NTFJMSConnection[] jmsListenerConnections = null;
    private HashMap<Long, Integer> jmsRegIdToJDBCRegId = new HashMap();
    private String jmsClientId;
    private int noOfRegistrationsInDB = 0;
    String databaseUniqueIdentifier;
    private static final int MAX_NTF_CONNECTIONS = 2;
    String[] databaseInstances = null;
    boolean isInitialized = false;
    ArrayList<String> listenerAddresses = null;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Thu_Apr_04_15:09:24_PDT_2013";
    public static final boolean TRACE = false;

    NTFJMSPerDatabaseManager(String string) {
        this.databaseUniqueIdentifier = string;
    }

    void init(String string, String[] stringArray, ArrayList<String> arrayList) {
        this.jmsClientId = string;
        this.databaseInstances = stringArray;
        this.listenerAddresses = arrayList;
        this.isInitialized = true;
    }

    synchronized void closeJMSListenerConnection() {
        if (this.noOfRegistrationsInDB == 0 && this.jmsListenerConnections != null) {
            for (int i2 = 0; i2 < this.jmsListenerConnections.length; ++i2) {
                if (this.jmsListenerConnections[i2] == null) continue;
                this.jmsListenerConnections[i2].closeThisListener();
                this.jmsListenerConnections[i2].interrupt();
                PhysicalConnection.ntfManager.removeJMSUtility(this.databaseUniqueIdentifier);
            }
            this.jmsListenerConnections = null;
        }
    }

    synchronized void startJMSListenerConnection(String string, String string2, String string3) {
        assert (this.jmsClientId != null) : "jmsClientId is null";
        if (this.jmsListenerConnections == null || this.jmsListenerConnections.length == 0) {
            int n2 = this.databaseInstances.length > 2 ? 2 : this.databaseInstances.length;
            this.jmsListenerConnections = new NTFJMSConnection[n2];
            for (int i2 = 0; i2 < n2; ++i2) {
                String string4 = "notify" + i2;
                this.jmsListenerConnections[i2] = new NTFJMSConnection(this, this.jmsClientId, this.listenerAddresses, this.databaseInstances[i2], string, string2, string3, string4);
                this.jmsListenerConnections[i2].setDaemon(true);
                this.jmsListenerConnections[i2].start();
            }
        }
    }

    String getJMSClientId() {
        return this.jmsClientId;
    }

    public void setJmsClientId(String string) {
        this.jmsClientId = string;
    }

    void removeRegistrationId(Long l2) {
        this.jmsRegIdToJDBCRegId.remove(l2);
    }

    int getJDBCRegId(Long l2) {
        return this.jmsRegIdToJDBCRegId.get(l2);
    }

    void mapJMSRegIdToJDBCRegId(Long l2, int n2) {
        this.jmsRegIdToJDBCRegId.put(l2, n2);
    }

    void incrementNumberOfRegistrations() {
        ++this.noOfRegistrationsInDB;
    }

    void decrementNumberOfRegistrations() {
        --this.noOfRegistrationsInDB;
    }
}

