/*
 * Decompiled with CFR 0.152.
 */
package com.kyexpress.openapi.sdk.utils;

import com.fasterxml.jackson.core.type.TypeReference;
import com.kyexpress.openapi.sdk.builder.ApiBuilder;
import com.kyexpress.openapi.sdk.builder.AppBuilder;
import com.kyexpress.openapi.sdk.exception.KyeOpenApiException;
import com.kyexpress.openapi.sdk.model.RequestHolder;
import com.kyexpress.openapi.sdk.model.StandardResponse;
import com.kyexpress.openapi.sdk.model.TokenInfo;
import com.kyexpress.openapi.sdk.utils.HttpUtils;
import com.kyexpress.openapi.sdk.utils.JsonUtils;
import com.kyexpress.openapi.sdk.utils.KyeHashMap;
import com.kyexpress.openapi.sdk.utils.MD5Utils;
import com.kyexpress.openapi.sdk.utils.StringUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class KyeOpenApiUtils {
    private static Map<String, String> tokenMap = new ConcurrentHashMap<String, String>();

    public static String execOpenApiInvoke(ApiBuilder apiBuilder) throws KyeOpenApiException {
        AppBuilder appBuilder = apiBuilder.getAppBuilder();
        if (StringUtils.isEmpty(appBuilder.getAppKey())) {
            throw new KyeOpenApiException("appKey is null");
        }
        if (StringUtils.isEmpty(appBuilder.getAppSecret())) {
            throw new KyeOpenApiException(appBuilder.getAppKey() + " " + "appSecret is null");
        }
        if (StringUtils.isEmpty(apiBuilder.getApiCode())) {
            throw new KyeOpenApiException(appBuilder.getAppKey() + " " + "apiCode is null");
        }
        if (apiBuilder.getBody() != null) {
            try {
                if (String.class.isAssignableFrom(apiBuilder.getBody().getClass())) {
                    apiBuilder.body(apiBuilder.getBody().toString());
                } else {
                    apiBuilder.body(JsonUtils.deserializer(apiBuilder.getBody()));
                }
            }
            catch (Exception e) {
                throw new KyeOpenApiException(appBuilder.getAppKey(), apiBuilder.getApiCode(), "JSON dserialize error", e);
            }
        }
        RequestHolder requestHolder = KyeOpenApiUtils.getRestRequstHolder(apiBuilder);
        return KyeOpenApiUtils.executeRest(requestHolder, apiBuilder);
    }

    private static synchronized String getToken(AppBuilder appBuilder, ApiBuilder apiBuilder) throws KyeOpenApiException {
        String tokenKey = appBuilder.getDomain() + appBuilder.getAppKey();
        if (tokenMap != null && tokenMap.containsKey(tokenKey) && !StringUtils.isEmpty(tokenMap.get(tokenKey))) {
            return tokenMap.get(tokenKey);
        }
        RequestHolder requestHolder = KyeOpenApiUtils.getTokenRequestHolder(appBuilder);
        TokenInfo tokenInfo = KyeOpenApiUtils.getTokenValue(requestHolder, apiBuilder);
        if (tokenInfo != null && tokenInfo.getToken() != null) {
            tokenMap.put(tokenKey, tokenInfo.getToken());
            return tokenInfo.getToken();
        }
        return null;
    }

    public static void removeToken(String appKey) {
        tokenMap.remove(appKey);
    }

    private static RequestHolder getRestRequstHolder(ApiBuilder apiBuilder) throws KyeOpenApiException {
        String token = KyeOpenApiUtils.getToken(apiBuilder.getAppBuilder(), apiBuilder);
        if (token == null) {
            throw new KyeOpenApiException(apiBuilder.getAppBuilder().getAppKey() + " " + "TokenClient do post error");
        }
        RequestHolder requestHolder = new RequestHolder();
        String paramJson = apiBuilder.getBody() != null ? apiBuilder.getBody().toString() : "{}";
        String timestamp = String.valueOf(System.currentTimeMillis());
        String sign = KyeOpenApiUtils.getSign(apiBuilder.getAppBuilder().getAppSecret(), timestamp, paramJson);
        KyeHashMap headerMap = new KyeHashMap();
        headerMap.put("Content-Type", "application/json;charset=UTF-8");
        headerMap.put("token", token);
        headerMap.put("appkey", apiBuilder.getAppBuilder().getAppKey());
        headerMap.put("sign", sign);
        headerMap.put("format", "json");
        headerMap.put("timestamp", timestamp);
        headerMap.put("method", apiBuilder.getApiCode());
        if (apiBuilder.getHeaders() != null) {
            headerMap.putAll(apiBuilder.getHeaders());
        }
        requestHolder.setBodyContent(paramJson);
        requestHolder.setHeaderMap(headerMap);
        return requestHolder;
    }

    private static String executeRest(RequestHolder requestHolder, ApiBuilder apiBuilder) throws KyeOpenApiException {
        if (StringUtils.isEmpty(apiBuilder.getAppBuilder().getDomain())) {
            throw new KyeOpenApiException(apiBuilder.getAppBuilder().getAppKey() + " " + "OpenApi Domain is Empty" + " env: " + apiBuilder.getAppBuilder().getEnv());
        }
        String restUrl = null;
        restUrl = apiBuilder.getSandbox() ? apiBuilder.getAppBuilder().getDomain() + "/sandbox/router/rest" : apiBuilder.getAppBuilder().getDomain() + "/router/rest";
        String rspResult = null;
        try {
            rspResult = HttpUtils.doPost(restUrl, requestHolder, apiBuilder.getConnectTimeout(), apiBuilder.getReadTimeout());
        }
        catch (Exception e) {
            throw new KyeOpenApiException(apiBuilder.getAppBuilder().getAppKey(), apiBuilder.getApiCode(), e);
        }
        return rspResult;
    }

    private static TokenInfo getTokenValue(RequestHolder holder, ApiBuilder apiBuilder) throws KyeOpenApiException {
        if (StringUtils.isEmpty(apiBuilder.getAppBuilder().getDomain())) {
            throw new KyeOpenApiException("OpenApi Domain is Empty env: " + apiBuilder.getAppBuilder().getEnv());
        }
        String rspResult = null;
        String url = null;
        url = apiBuilder.getSandbox() ? apiBuilder.getAppBuilder().getDomain() + "/security/sandbox/accessToken" : apiBuilder.getAppBuilder().getDomain() + "/security/token";
        int retry = 2;
        while (retry-- > 0) {
            try {
                rspResult = HttpUtils.doPost(url, holder, apiBuilder.getConnectTimeout(), apiBuilder.getReadTimeout());
                break;
            }
            catch (Exception e) {
                if (retry != 0) continue;
                throw new KyeOpenApiException(apiBuilder.getAppBuilder().getAppKey() + " " + "TOKEN_REQUEST_ERROR" + " : " + url + " : " + e.getClass().getName(), e);
            }
        }
        if (rspResult == null || rspResult.trim().length() == 0) {
            throw new KyeOpenApiException(apiBuilder.getAppBuilder().getAppKey() + " " + "TOKEN_RESPONSE_ERROR" + " : " + url + " : " + rspResult);
        }
        StandardResponse response = null;
        try {
            response = (StandardResponse)JsonUtils.serializable(rspResult, new TypeReference<StandardResponse<TokenInfo>>(){});
        }
        catch (Exception e) {
            throw new KyeOpenApiException(apiBuilder.getAppBuilder().getAppKey() + " " + "TOKEN_RESPONSE_ERROR" + " : " + url + " : " + rspResult, e);
        }
        if (response == null || response.getData() == null || Boolean.FALSE.equals(response.getSuccess())) {
            throw new KyeOpenApiException(apiBuilder.getAppBuilder().getAppKey() + " " + "TOKEN_RESPONSE_ERROR" + " : " + url + " : " + rspResult);
        }
        return (TokenInfo)response.getData();
    }

    private static RequestHolder getTokenRequestHolder(AppBuilder appBuilder) throws KyeOpenApiException {
        RequestHolder requestHolder = new RequestHolder();
        try {
            HashMap<String, String> appInfo = new HashMap<String, String>();
            appInfo.put("appkey", appBuilder.getAppKey());
            appInfo.put("appsecret", appBuilder.getAppSecret());
            requestHolder.setBodyContent(JsonUtils.deserializer(appInfo));
        }
        catch (Exception e) {
            throw new KyeOpenApiException("JSON dserialize error", e);
        }
        KyeHashMap headerMap = new KyeHashMap();
        headerMap.put("Content-Type", "application/json;charset=UTF-8");
        if (appBuilder.getFrom() == null) {
            headerMap.put("x-from", "openapi_app");
        } else {
            headerMap.put("x-from", appBuilder.getFrom());
        }
        requestHolder.setHeaderMap(headerMap);
        return requestHolder;
    }

    public static String getSign(String appSecret, String timestamp, String appParam) throws KyeOpenApiException {
        try {
            StringBuilder content = new StringBuilder();
            content.append(appSecret).append(timestamp).append(appParam);
            return MD5Utils.md5(content.toString(), "UTF-8", "").toUpperCase();
        }
        catch (Exception e) {
            throw new KyeOpenApiException("Signature failure", e);
        }
    }
}

