package com.qimen.api.request;

import com.taobao.api.internal.util.RequestCheckUtils;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.qimen.api.QimenRequest;
import com.taobao.api.internal.util.TaobaoHashMap;

import com.qimen.api.response.PresalespackageConsignResponse;

/**
 * TOP API: taobao.qimen.presalespackage.consign request
 * 
 * @author top auto create
 * @since 1.0, 2023.07.04
 */
public class PresalespackageConsignRequest extends QimenRequest<PresalespackageConsignResponse> {
	
	

	/** 
	* 扩展信息Map
	 */
	private String extendProps;

	/** 
	* 外部订单号
	 */
	private String orderCode;

	/** 
	* 货主编码
	 */
	private String ownerCode;

	/** 
	* 支付时间
	 */
	private String payTime;

	/** 
	* 备注
	 */
	private String remark;

	/** 
	* 金额(单位为分)
	 */
	private Long totalAmount;

	public void setExtendProps(String extendProps) {
		this.extendProps = extendProps;
	}

	public String getExtendProps() {
		return this.extendProps;
	}

	public void setOrderCode(String orderCode) {
		this.orderCode = orderCode;
	}

	public String getOrderCode() {
		return this.orderCode;
	}

	public void setOwnerCode(String ownerCode) {
		this.ownerCode = ownerCode;
	}

	public String getOwnerCode() {
		return this.ownerCode;
	}

	public void setPayTime(String payTime) {
		this.payTime = payTime;
	}

	public String getPayTime() {
		return this.payTime;
	}

	public void setRemark(String remark) {
		this.remark = remark;
	}

	public String getRemark() {
		return this.remark;
	}

	public void setTotalAmount(Long totalAmount) {
		this.totalAmount = totalAmount;
	}

	public Long getTotalAmount() {
		return this.totalAmount;
	}

	public String getApiMethodName() {
		return "taobao.qimen.presalespackage.consign";
	}

	public Class<PresalespackageConsignResponse> getResponseClass() {
		return PresalespackageConsignResponse.class;
	}

	public void check() throws ApiRuleException {
		RequestCheckUtils.checkNotEmpty(orderCode, "orderCode");
		RequestCheckUtils.checkNotEmpty(ownerCode, "ownerCode");
		RequestCheckUtils.checkNotEmpty(payTime, "payTime");
		RequestCheckUtils.checkNotEmpty(totalAmount, "totalAmount");
	}
	

}