package com.qimen.api.request;

import java.util.List;
import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.internal.util.RequestCheckUtils;
import com.taobao.api.TaobaoObject;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.qimen.api.QimenRequest;
import com.taobao.api.internal.util.TaobaoHashMap;

import com.qimen.api.response.ReplenishplanCreateResponse;

/**
 * TOP API: taobao.qimen.replenishplan.create request
 * 
 * @author top auto create
 * @since 1.0, 2022.04.12
 */
public class ReplenishplanCreateRequest extends QimenRequest<ReplenishplanCreateResponse> {
	
	

	/** 
	* 扩展属性
	 */
	private java.util.Map extendProps;

	/** 
	* 最晚入库时间(YYYY-MM-DD HH:MM:SS)
	 */
	private String gmtDeadTime;

	/** 
	* 单据信息
	 */
	private List<ReplenishplanCreateItem> items;

	/** 
	* 外部系统单号(ERP单号)
	 */
	private String orderCode;

	/** 
	* 商家ID
	 */
	private String userId;

	/** 
	* 仓库编码
	 */
	private String warehouseCode;

	public void setExtendProps(java.util.Map extendProps) {
		this.extendProps = extendProps;
	}

	public java.util.Map getExtendProps() {
		return this.extendProps;
	}

	public void setGmtDeadTime(String gmtDeadTime) {
		this.gmtDeadTime = gmtDeadTime;
	}

	public String getGmtDeadTime() {
		return this.gmtDeadTime;
	}

	public void setItems(List<ReplenishplanCreateItem> items) {
		this.items = items;
	}

	public List<ReplenishplanCreateItem> getItems() {
		return this.items;
	}

	public void setOrderCode(String orderCode) {
		this.orderCode = orderCode;
	}

	public String getOrderCode() {
		return this.orderCode;
	}

	public void setUserId(String userId) {
		this.userId = userId;
	}

	public String getUserId() {
		return this.userId;
	}

	public void setWarehouseCode(String warehouseCode) {
		this.warehouseCode = warehouseCode;
	}

	public String getWarehouseCode() {
		return this.warehouseCode;
	}

	public String getApiMethodName() {
		return "taobao.qimen.replenishplan.create";
	}

	public Class<ReplenishplanCreateResponse> getResponseClass() {
		return ReplenishplanCreateResponse.class;
	}

	public void check() throws ApiRuleException {
		RequestCheckUtils.checkNotEmpty(gmtDeadTime, "gmtDeadTime");
		RequestCheckUtils.checkMaxLength(gmtDeadTime, 19, "gmtDeadTime");
		RequestCheckUtils.checkNotEmpty(orderCode, "orderCode");
		RequestCheckUtils.checkMaxLength(orderCode, 50, "orderCode");
		RequestCheckUtils.checkNotEmpty(userId, "userId");
		RequestCheckUtils.checkMaxLength(userId, 50, "userId");
		RequestCheckUtils.checkNotEmpty(warehouseCode, "warehouseCode");
		RequestCheckUtils.checkMaxLength(warehouseCode, 50, "warehouseCode");
	}
	
	/**
 * 单据信息
 *
 * @author top auto create
 * @since 1.0, null
 */
 
public static class ReplenishplanCreateItem {

	/**
		 * 后端商品编码
		 */
		@ApiField("itemId")
		private String itemId;
		/**
		 * 计划入库数量
		 */
		@ApiField("quantity")
		private Long quantity;
	

	public String getItemId() {
			return this.itemId;
		}
		public void setItemId(String itemId) {
			this.itemId = itemId;
		}
		public Long getQuantity() {
			return this.quantity;
		}
		public void setQuantity(Long quantity) {
			this.quantity = quantity;
		}

}


}