package com.qimen.api.request;

import java.util.List;
import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.internal.mapping.ApiListType;
import com.taobao.api.TaobaoObject;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.qimen.api.QimenRequest;
import com.taobao.api.internal.util.TaobaoHashMap;

import com.qimen.api.response.ReturnapplyReportResponse;

/**
 * TOP API: taobao.qimen.returnapply.report request
 * 
 * @author top auto create
 * @since 1.0, 2019.11.20
 */
public class ReturnapplyReportRequest extends QimenRequest<ReturnapplyReportResponse> {
	
	

	/** 
	* 缺货回告创建时间,,string (19),必填,
	 */
	private String createDate;

	/** 
	* 创建人,,string (50),,
	 */
	private String createEmp;

	/** 
	* 运单号,, string (50) , 必填,
	 */
	private String expressCode;

	/** 
	* items
	 */
	private List<Item> items;

	/** 
	* 物流公司编码,,string (50), SF=顺丰、EMS=标准快递、EYB=经济快件、ZJS=宅急送、YTO=圆通  、ZTO=中通 (ZTO) 、HTKY=百世汇通、BSKY=百世快运、UC=优速、STO=申通、TTKDEX=天天快递  、QFKD=全峰、FAST=快捷、POSTB=邮政小包  、GTO=国通、YUNDA=韵达、JD=京东配送、DD=当当宅配、AMAZON=亚马逊物流、DBWL=德邦物流、DBKD=德邦快递、DBKY=德邦快运、RRS=日日顺、OTHER=其他,必填,
	 */
	private String logisticsCode;

	/** 
	* 物流公司名称,,string (200),,
	 */
	private String logisticsName;

	/** 
	* ERP的发货单编码,,string (50),必填,
	 */
	private String orderCode;

	/** 
	* 仓库系统的发货单编码,,string (50),,
	 */
	private String orderId;

	/** 
	* receiverInfo
	 */
	private ReceiverInfo receiverInfo;

	/** 
	* 备注,,string (200),,
	 */
	private String remark;

	/** 
	* 店铺编码,  string (50) ,  必填
	 */
	private String shopCode;

	/** 
	* 仓库编码,,string (50),必填,
	 */
	private String warehouseCode;

	public void setCreateDate(String createDate) {
		this.createDate = createDate;
	}

	public String getCreateDate() {
		return this.createDate;
	}

	public void setCreateEmp(String createEmp) {
		this.createEmp = createEmp;
	}

	public String getCreateEmp() {
		return this.createEmp;
	}

	public void setExpressCode(String expressCode) {
		this.expressCode = expressCode;
	}

	public String getExpressCode() {
		return this.expressCode;
	}

	public void setItems(List<Item> items) {
		this.items = items;
	}

	public List<Item> getItems() {
		return this.items;
	}

	public void setLogisticsCode(String logisticsCode) {
		this.logisticsCode = logisticsCode;
	}

	public String getLogisticsCode() {
		return this.logisticsCode;
	}

	public void setLogisticsName(String logisticsName) {
		this.logisticsName = logisticsName;
	}

	public String getLogisticsName() {
		return this.logisticsName;
	}

	public void setOrderCode(String orderCode) {
		this.orderCode = orderCode;
	}

	public String getOrderCode() {
		return this.orderCode;
	}

	public void setOrderId(String orderId) {
		this.orderId = orderId;
	}

	public String getOrderId() {
		return this.orderId;
	}

	public void setReceiverInfo(ReceiverInfo receiverInfo) {
		this.receiverInfo = receiverInfo;
	}

	public ReceiverInfo getReceiverInfo() {
		return this.receiverInfo;
	}

	public void setRemark(String remark) {
		this.remark = remark;
	}

	public String getRemark() {
		return this.remark;
	}

	public void setShopCode(String shopCode) {
		this.shopCode = shopCode;
	}

	public String getShopCode() {
		return this.shopCode;
	}

	public void setWarehouseCode(String warehouseCode) {
		this.warehouseCode = warehouseCode;
	}

	public String getWarehouseCode() {
		return this.warehouseCode;
	}

	public String getApiMethodName() {
		return "taobao.qimen.returnapply.report";
	}

	public Class<ReturnapplyReportResponse> getResponseClass() {
		return ReturnapplyReportResponse.class;
	}

	public void check() throws ApiRuleException {
	}
	
	/**
 * receiverInfo
 *
 * @author top auto create
 * @since 1.0, null
 */
 
public static class ReceiverInfo {

	/**
		 * 区域, ,string (50) ,,
		 */
		@ApiField("area")
		private String area;
		/**
		 * 城市,, string (50) , 必填,
		 */
		@ApiField("city")
		private String city;
		/**
		 * 国家二字码,,string(50),,
		 */
		@ApiField("countryCode")
		private String countryCode;
		/**
		 * 详细地址, ,string (200) , 必填,
		 */
		@ApiField("detailAddress")
		private String detailAddress;
		/**
		 * 移动电话, ,string (50) , 必填,
		 */
		@ApiField("mobile")
		private String mobile;
		/**
		 * 姓名,,string (50) , 必填,
		 */
		@ApiField("name")
		private String name;
		/**
		 * 省份, ,string (50) , 必填,
		 */
		@ApiField("province")
		private String province;
		/**
		 * 固定电话, ,string (50) ,
		 */
		@ApiField("tel")
		private String tel;
		/**
		 * 村镇, ,string (50) ,,
		 */
		@ApiField("town")
		private String town;
		/**
		 * 邮编, ,string (50) ,,
		 */
		@ApiField("zipCode")
		private String zipCode;
	

	public String getArea() {
			return this.area;
		}
		public void setArea(String area) {
			this.area = area;
		}
		public String getCity() {
			return this.city;
		}
		public void setCity(String city) {
			this.city = city;
		}
		public String getCountryCode() {
			return this.countryCode;
		}
		public void setCountryCode(String countryCode) {
			this.countryCode = countryCode;
		}
		public String getDetailAddress() {
			return this.detailAddress;
		}
		public void setDetailAddress(String detailAddress) {
			this.detailAddress = detailAddress;
		}
		public String getMobile() {
			return this.mobile;
		}
		public void setMobile(String mobile) {
			this.mobile = mobile;
		}
		public String getName() {
			return this.name;
		}
		public void setName(String name) {
			this.name = name;
		}
		public String getProvince() {
			return this.province;
		}
		public void setProvince(String province) {
			this.province = province;
		}
		public String getTel() {
			return this.tel;
		}
		public void setTel(String tel) {
			this.tel = tel;
		}
		public String getTown() {
			return this.town;
		}
		public void setTown(String town) {
			this.town = town;
		}
		public String getZipCode() {
			return this.zipCode;
		}
		public void setZipCode(String zipCode) {
			this.zipCode = zipCode;
		}

}

	/**
 * items
 *
 * @author top auto create
 * @since 1.0, null
 */
 @ApiListType("item")
public static class Item {

	/**
		 * 批次编码, ,string (50) ,,
		 */
		@ApiField("batchCode")
		private String batchCode;
		/**
		 * 商品过期日期, ,string (50) ,,
		 */
		@ApiField("expireDate")
		private String expireDate;
		/**
		 * 库存类型,string (50) , ,
		 */
		@ApiField("inventoryType")
		private String inventoryType;
		/**
		 * 商品编码, ,string (50) , 必填,
		 */
		@ApiField("itemCode")
		private String itemCode;
		/**
		 * 仓储系统商品编码, ,string (50) , ,
		 */
		@ApiField("itemId")
		private String itemId;
		/**
		 * 商品状态，string（50），ZC=正常，PS=破损
		 */
		@ApiField("itemStatus")
		private String itemStatus;
		/**
		 * 商品数量, ,string (50), 必填,
		 */
		@ApiField("planQty")
		private String planQty;
		/**
		 * 生产批号, ,string (50) ,,
		 */
		@ApiField("produceCode")
		private String produceCode;
		/**
		 * 商品生产日期, ,string (50) ,,
		 */
		@ApiField("productDate")
		private String productDate;
		/**
		 * 备注, string (500)
		 */
		@ApiField("remark")
		private String remark;
	

	public String getBatchCode() {
			return this.batchCode;
		}
		public void setBatchCode(String batchCode) {
			this.batchCode = batchCode;
		}
		public String getExpireDate() {
			return this.expireDate;
		}
		public void setExpireDate(String expireDate) {
			this.expireDate = expireDate;
		}
		public String getInventoryType() {
			return this.inventoryType;
		}
		public void setInventoryType(String inventoryType) {
			this.inventoryType = inventoryType;
		}
		public String getItemCode() {
			return this.itemCode;
		}
		public void setItemCode(String itemCode) {
			this.itemCode = itemCode;
		}
		public String getItemId() {
			return this.itemId;
		}
		public void setItemId(String itemId) {
			this.itemId = itemId;
		}
		public String getItemStatus() {
			return this.itemStatus;
		}
		public void setItemStatus(String itemStatus) {
			this.itemStatus = itemStatus;
		}
		public String getPlanQty() {
			return this.planQty;
		}
		public void setPlanQty(String planQty) {
			this.planQty = planQty;
		}
		public String getProduceCode() {
			return this.produceCode;
		}
		public void setProduceCode(String produceCode) {
			this.produceCode = produceCode;
		}
		public String getProductDate() {
			return this.productDate;
		}
		public void setProductDate(String productDate) {
			this.productDate = productDate;
		}
		public String getRemark() {
			return this.remark;
		}
		public void setRemark(String remark) {
			this.remark = remark;
		}

}


}