package com.qimen.api.request;

import com.taobao.api.internal.util.RequestCheckUtils;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.qimen.api.QimenRequest;
import com.taobao.api.internal.util.TaobaoHashMap;

import com.qimen.api.response.ReturnorderQueryResponse;

/**
 * TOP API: taobao.qimen.returnorder.query request
 * 
 * @author top auto create
 * @since 1.0, 2022.04.12
 */
public class ReturnorderQueryRequest extends QimenRequest<ReturnorderQueryResponse> {
	
	

	/** 
	* 扩展属性
	 */
	private java.util.Map extendProps;

	/** 
	* 货主编码
	 */
	private String ownerCode;

	/** 
	* 当前页(从1开始)
	 */
	private Long page;

	/** 
	* 每页orderLine条数(最多100条)
	 */
	private Long pageSize;

	/** 
	* 退货单编码
	 */
	private String returnOrderCode;

	/** 
	* 仓库系统订单编码
	 */
	private String returnOrderId;

	/** 
	* 仓库编码
	 */
	private String warehouseCode;

	public void setExtendProps(java.util.Map extendProps) {
		this.extendProps = extendProps;
	}

	public java.util.Map getExtendProps() {
		return this.extendProps;
	}

	public void setOwnerCode(String ownerCode) {
		this.ownerCode = ownerCode;
	}

	public String getOwnerCode() {
		return this.ownerCode;
	}

	public void setPage(Long page) {
		this.page = page;
	}

	public Long getPage() {
		return this.page;
	}

	public void setPageSize(Long pageSize) {
		this.pageSize = pageSize;
	}

	public Long getPageSize() {
		return this.pageSize;
	}

	public void setReturnOrderCode(String returnOrderCode) {
		this.returnOrderCode = returnOrderCode;
	}

	public String getReturnOrderCode() {
		return this.returnOrderCode;
	}

	public void setReturnOrderId(String returnOrderId) {
		this.returnOrderId = returnOrderId;
	}

	public String getReturnOrderId() {
		return this.returnOrderId;
	}

	public void setWarehouseCode(String warehouseCode) {
		this.warehouseCode = warehouseCode;
	}

	public String getWarehouseCode() {
		return this.warehouseCode;
	}

	public String getApiMethodName() {
		return "taobao.qimen.returnorder.query";
	}

	public Class<ReturnorderQueryResponse> getResponseClass() {
		return ReturnorderQueryResponse.class;
	}

	public void check() throws ApiRuleException {
		RequestCheckUtils.checkMaxLength(ownerCode, 50, "ownerCode");
		RequestCheckUtils.checkNotEmpty(page, "page");
		RequestCheckUtils.checkNotEmpty(pageSize, "pageSize");
		RequestCheckUtils.checkNotEmpty(returnOrderCode, "returnOrderCode");
		RequestCheckUtils.checkMaxLength(returnOrderCode, 50, "returnOrderCode");
		RequestCheckUtils.checkMaxLength(returnOrderId, 50, "returnOrderId");
		RequestCheckUtils.checkMaxLength(warehouseCode, 50, "warehouseCode");
	}
	

}