package com.qimen.api.request;

import java.util.List;
import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.internal.mapping.ApiListType;
import com.taobao.api.TaobaoObject;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.qimen.api.QimenRequest;
import com.taobao.api.internal.util.TaobaoHashMap;

import com.qimen.api.response.TransferorderReportResponse;

/**
 * TOP API: taobao.qimen.transferorder.report request
 * 
 * @author top auto create
 * @since 1.0, 2021.09.02
 */
public class TransferorderReportRequest extends QimenRequest<TransferorderReportResponse> {
	
	

	/** 
	* 确认入库时间
	 */
	private String confirmInTime;

	/** 
	* 确认出库时间
	 */
	private String confirmOutTime;

	/** 
	* 调拨单创建时间
	 */
	private String createTime;

	/** 
	* erpOrderCode
	 */
	private String erpOrderCode;

	/** 
	* 调拨出库仓编码
	 */
	private String fromWarehouseCode;

	/** 
	* 项目集
	 */
	private List<Items> items;

	/** 
	* orderStatus
	 */
	private String orderStatus;

	/** 
	* 111
	 */
	private String ownerCode;

	/** 
	* 调拨入库仓编码
	 */
	private String toWarehouseCode;

	/** 
	* 调拨入库单号
	 */
	private String transferInOrderCode;

	/** 
	* 调拨单号,0,string(50),必填,
	 */
	private String transferOrderCode;

	/** 
	* 调拨出库单号
	 */
	private String transferOutOrderCode;

	public void setConfirmInTime(String confirmInTime) {
		this.confirmInTime = confirmInTime;
	}

	public String getConfirmInTime() {
		return this.confirmInTime;
	}

	public void setConfirmOutTime(String confirmOutTime) {
		this.confirmOutTime = confirmOutTime;
	}

	public String getConfirmOutTime() {
		return this.confirmOutTime;
	}

	public void setCreateTime(String createTime) {
		this.createTime = createTime;
	}

	public String getCreateTime() {
		return this.createTime;
	}

	public void setErpOrderCode(String erpOrderCode) {
		this.erpOrderCode = erpOrderCode;
	}

	public String getErpOrderCode() {
		return this.erpOrderCode;
	}

	public void setFromWarehouseCode(String fromWarehouseCode) {
		this.fromWarehouseCode = fromWarehouseCode;
	}

	public String getFromWarehouseCode() {
		return this.fromWarehouseCode;
	}

	public void setItems(List<Items> items) {
		this.items = items;
	}

	public List<Items> getItems() {
		return this.items;
	}

	public void setOrderStatus(String orderStatus) {
		this.orderStatus = orderStatus;
	}

	public String getOrderStatus() {
		return this.orderStatus;
	}

	public void setOwnerCode(String ownerCode) {
		this.ownerCode = ownerCode;
	}

	public String getOwnerCode() {
		return this.ownerCode;
	}

	public void setToWarehouseCode(String toWarehouseCode) {
		this.toWarehouseCode = toWarehouseCode;
	}

	public String getToWarehouseCode() {
		return this.toWarehouseCode;
	}

	public void setTransferInOrderCode(String transferInOrderCode) {
		this.transferInOrderCode = transferInOrderCode;
	}

	public String getTransferInOrderCode() {
		return this.transferInOrderCode;
	}

	public void setTransferOrderCode(String transferOrderCode) {
		this.transferOrderCode = transferOrderCode;
	}

	public String getTransferOrderCode() {
		return this.transferOrderCode;
	}

	public void setTransferOutOrderCode(String transferOutOrderCode) {
		this.transferOutOrderCode = transferOutOrderCode;
	}

	public String getTransferOutOrderCode() {
		return this.transferOutOrderCode;
	}

	public String getApiMethodName() {
		return "taobao.qimen.transferorder.report";
	}

	public Class<TransferorderReportResponse> getResponseClass() {
		return TransferorderReportResponse.class;
	}

	public void check() throws ApiRuleException {
	}
	
	/**
 * 项目集
 *
 * @author top auto create
 * @since 1.0, null
 */
 @ApiListType("item")
public static class Items {

	/**
		 * 实际出库数量,Item1234,string(50),,
		 */
		@ApiField("inCount")
		private String inCount;
		/**
		 * 库存类型(1:可销售库存.101:残次),HZ1234,string(500),,
		 */
		@ApiField("inventoryType")
		private String inventoryType;
		/**
		 * 实际出库数量,Item1234,string(50),,
		 */
		@ApiField("outCount")
		private String outCount;
		/**
		 * 计划调拨数量
		 */
		@ApiField("planCount")
		private String planCount;
		/**
		 * 货品编码,HZ1234,string(50),,
		 */
		@ApiField("scItemCode")
		private String scItemCode;
	

	public String getInCount() {
			return this.inCount;
		}
		public void setInCount(String inCount) {
			this.inCount = inCount;
		}
		public String getInventoryType() {
			return this.inventoryType;
		}
		public void setInventoryType(String inventoryType) {
			this.inventoryType = inventoryType;
		}
		public String getOutCount() {
			return this.outCount;
		}
		public void setOutCount(String outCount) {
			this.outCount = outCount;
		}
		public String getPlanCount() {
			return this.planCount;
		}
		public void setPlanCount(String planCount) {
			this.planCount = planCount;
		}
		public String getScItemCode() {
			return this.scItemCode;
		}
		public void setScItemCode(String scItemCode) {
			this.scItemCode = scItemCode;
		}

}


}