package com.qimen.api.response;

import java.util.List;
import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.internal.mapping.ApiListField;
import com.taobao.api.TaobaoObject;

import com.qimen.api.QimenResponse;

/**
 * TOP API: taobao.qimen.inventorycheck.query response.
 * 
 * @author top auto create
 * @since 1.0, null
 */
public class InventorycheckQueryResponse extends QimenResponse {

	private static final long serialVersionUID = 2453133165371544169L;

	/** 
	 * 盘点单编码
	 */
	@ApiField("checkOrderCode")
	private String checkOrderCode;

	/** 
	 * 仓储系统的盘点单编码
	 */
	@ApiField("checkOrderId")
	private String checkOrderId;

	/** 
	 * 盘点时间(YYYY-MM-DD HH:MM:SS)
	 */
	@ApiField("checkTime")
	private String checkTime;

	/** 
	 * 商品库存列表
	 */
	@ApiListField("items")
	@ApiField("item")
	private List<Item> items;

	/** 
	 * 货主编码
	 */
	@ApiField("ownerCode")
	private String ownerCode;

	/** 
	 * 备注
	 */
	@ApiField("remark")
	private String remark;

	/** 
	 * orderLines总条数
	 */
	@ApiField("totalLines")
	private Long totalLines;

	/** 
	 * 仓库编码
	 */
	@ApiField("warehouseCode")
	private String warehouseCode;


	public void setCheckOrderCode(String checkOrderCode) {
		this.checkOrderCode = checkOrderCode;
	}
	public String getCheckOrderCode( ) {
		return this.checkOrderCode;
	}

	public void setCheckOrderId(String checkOrderId) {
		this.checkOrderId = checkOrderId;
	}
	public String getCheckOrderId( ) {
		return this.checkOrderId;
	}

	public void setCheckTime(String checkTime) {
		this.checkTime = checkTime;
	}
	public String getCheckTime( ) {
		return this.checkTime;
	}

	public void setItems(List<Item> items) {
		this.items = items;
	}
	public List<Item> getItems( ) {
		return this.items;
	}

	public void setOwnerCode(String ownerCode) {
		this.ownerCode = ownerCode;
	}
	public String getOwnerCode( ) {
		return this.ownerCode;
	}

	public void setRemark(String remark) {
		this.remark = remark;
	}
	public String getRemark( ) {
		return this.remark;
	}

	public void setTotalLines(Long totalLines) {
		this.totalLines = totalLines;
	}
	public Long getTotalLines( ) {
		return this.totalLines;
	}

	public void setWarehouseCode(String warehouseCode) {
		this.warehouseCode = warehouseCode;
	}
	public String getWarehouseCode( ) {
		return this.warehouseCode;
	}
	
	/**
 * 商品库存列表
 *
 * @author top auto create
 * @since 1.0, null
 */
 
public static class Item {

	/**
		 * 批次编码
		 */
		@ApiField("batchCode")
		private String batchCode;
		/**
		 * 商品过期日期(YYYY-MM-DD)
		 */
		@ApiField("expireDate")
		private String expireDate;
		/**
		 * 库存类型(ZP=正品;CC=残次;JS=机损;XS= 箱损;ZT=在途库存;默认为ZP)
		 */
		@ApiField("inventoryType")
		private String inventoryType;
		/**
		 * 商品编码
		 */
		@ApiField("itemCode")
		private String itemCode;
		/**
		 * 仓储系统商品ID
		 */
		@ApiField("itemId")
		private String itemId;
		/**
		 * 生产批号
		 */
		@ApiField("produceCode")
		private String produceCode;
		/**
		 * 商品生产日期(YYYY-MM-DD)
		 */
		@ApiField("productDate")
		private String productDate;
		/**
		 * 盘盈盘亏商品变化量(盘盈为正数;盘亏为负数)
		 */
		@ApiField("quantity")
		private Long quantity;
		/**
		 * 备注
		 */
		@ApiField("remark")
		private String remark;
		/**
		 * 商品序列号
		 */
		@ApiField("snCode")
		private String snCode;
	

	public String getBatchCode() {
			return this.batchCode;
		}
		public void setBatchCode(String batchCode) {
			this.batchCode = batchCode;
		}
		public String getExpireDate() {
			return this.expireDate;
		}
		public void setExpireDate(String expireDate) {
			this.expireDate = expireDate;
		}
		public String getInventoryType() {
			return this.inventoryType;
		}
		public void setInventoryType(String inventoryType) {
			this.inventoryType = inventoryType;
		}
		public String getItemCode() {
			return this.itemCode;
		}
		public void setItemCode(String itemCode) {
			this.itemCode = itemCode;
		}
		public String getItemId() {
			return this.itemId;
		}
		public void setItemId(String itemId) {
			this.itemId = itemId;
		}
		public String getProduceCode() {
			return this.produceCode;
		}
		public void setProduceCode(String produceCode) {
			this.produceCode = produceCode;
		}
		public String getProductDate() {
			return this.productDate;
		}
		public void setProductDate(String productDate) {
			this.productDate = productDate;
		}
		public Long getQuantity() {
			return this.quantity;
		}
		public void setQuantity(Long quantity) {
			this.quantity = quantity;
		}
		public String getRemark() {
			return this.remark;
		}
		public void setRemark(String remark) {
			this.remark = remark;
		}
		public String getSnCode() {
			return this.snCode;
		}
		public void setSnCode(String snCode) {
			this.snCode = snCode;
		}

}



}
