package com.taobao.api.domain;

import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.TaobaoObject;


/**
 * 组合品信息
 *
 * @author top auto create
 * @since 1.0, null
 */
public class CombineSubItemDO extends TaobaoObject {

	private static final long serialVersionUID = 3767771177142316599L;

	/**
	 * 苹果商品标
	 */
	@ApiField("apple_cc")
	private String appleCc;

	/**
	 * 成分品套餐原价
	 */
	@ApiField("combine_sub_item_fee")
	private Long combineSubItemFee;

	/**
	 * 教育优惠原价
	 */
	@ApiField("edu_original_fee")
	private Long eduOriginalFee;

	/**
	 * 套餐购成分品预计承诺时效(如果为时间格式为yyyy-MM-dd 则为绝对时间，为数字则为相对时间，比如7天内发货)
	 */
	@ApiField("estcon_time")
	private String estconTime;

	/**
	 * 套餐购是否商品主子成分品  
	 */
	@ApiField("ismain")
	private Boolean ismain;

	/**
	 * 商品数字编号
	 */
	@ApiField("item_id")
	private Long itemId;

	/**
	 * 商品名称
	 */
	@ApiField("item_name")
	private String itemName;

	/**
	 * 成分品原价
	 */
	@ApiField("origin_fee")
	private Long originFee;

	/**
	 * 商家外部编码(可与商家外部系统对接)。
	 */
	@ApiField("outer_iid")
	private String outerIid;

	/**
	 * outer_sku_id
	 */
	@ApiField("outer_sku_id")
	private String outerSkuId;

	/**
	 * 数量
	 */
	@ApiField("quantity")
	private Long quantity;

	/**
	 * 商品的最小库存单位Sku的id
	 */
	@ApiField("sku_id")
	private Long skuId;

	/**
	 * SKU标题
	 */
	@ApiField("sku_title")
	private String skuTitle;


	public String getAppleCc() {
		return this.appleCc;
	}
	public void setAppleCc(String appleCc) {
		this.appleCc = appleCc;
	}

	public Long getCombineSubItemFee() {
		return this.combineSubItemFee;
	}
	public void setCombineSubItemFee(Long combineSubItemFee) {
		this.combineSubItemFee = combineSubItemFee;
	}

	public Long getEduOriginalFee() {
		return this.eduOriginalFee;
	}
	public void setEduOriginalFee(Long eduOriginalFee) {
		this.eduOriginalFee = eduOriginalFee;
	}

	public String getEstconTime() {
		return this.estconTime;
	}
	public void setEstconTime(String estconTime) {
		this.estconTime = estconTime;
	}

	public Boolean getIsmain() {
		return this.ismain;
	}
	public void setIsmain(Boolean ismain) {
		this.ismain = ismain;
	}

	public Long getItemId() {
		return this.itemId;
	}
	public void setItemId(Long itemId) {
		this.itemId = itemId;
	}

	public String getItemName() {
		return this.itemName;
	}
	public void setItemName(String itemName) {
		this.itemName = itemName;
	}

	public Long getOriginFee() {
		return this.originFee;
	}
	public void setOriginFee(Long originFee) {
		this.originFee = originFee;
	}

	public String getOuterIid() {
		return this.outerIid;
	}
	public void setOuterIid(String outerIid) {
		this.outerIid = outerIid;
	}

	public String getOuterSkuId() {
		return this.outerSkuId;
	}
	public void setOuterSkuId(String outerSkuId) {
		this.outerSkuId = outerSkuId;
	}

	public Long getQuantity() {
		return this.quantity;
	}
	public void setQuantity(Long quantity) {
		this.quantity = quantity;
	}

	public Long getSkuId() {
		return this.skuId;
	}
	public void setSkuId(Long skuId) {
		this.skuId = skuId;
	}

	public String getSkuTitle() {
		return this.skuTitle;
	}
	public void setSkuTitle(String skuTitle) {
		this.skuTitle = skuTitle;
	}

}
