package com.taobao.api.domain;

import java.util.List;
import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.internal.mapping.ApiListField;
import com.taobao.api.TaobaoObject;


/**
 * 物流时效信息
 *
 * @author top auto create
 * @since 1.0, null
 */
public class LogisticsConsignInfo extends TaobaoObject {

	private static final long serialVersionUID = 1393458351169913293L;

	/**
	 * 成分品发货时效
	 */
	@ApiListField("combine_item")
	@ApiField("combine_consign_info")
	private List<CombineConsignInfo> combineItem;

	/**
	 * 商家的预计发货时间
	 */
	@ApiField("consign_time")
	private String consignTime;

	/**
	 * 时效关联的订单好
	 */
	@ApiField("related_id")
	private String relatedId;

	/**
	 * 商家的预计发货时间
	 */
	@ApiField("render_consign_time")
	private String renderConsignTime;


	public List<CombineConsignInfo> getCombineItem() {
		return this.combineItem;
	}
	public void setCombineItem(List<CombineConsignInfo> combineItem) {
		this.combineItem = combineItem;
	}

	public String getConsignTime() {
		return this.consignTime;
	}
	public void setConsignTime(String consignTime) {
		this.consignTime = consignTime;
	}

	public String getRelatedId() {
		return this.relatedId;
	}
	public void setRelatedId(String relatedId) {
		this.relatedId = relatedId;
	}

	public String getRenderConsignTime() {
		return this.renderConsignTime;
	}
	public void setRenderConsignTime(String renderConsignTime) {
		this.renderConsignTime = renderConsignTime;
	}

}
