package com.taobao.api.domain;

import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.TaobaoObject;


/**
 * 服务子订单列表
 *
 * @author top auto create
 * @since 1.0, null
 */
public class ServiceOrder extends TaobaoObject {

	private static final long serialVersionUID = 4764315396879358553L;

	/**
	 * appleCareEmail
	 */
	@ApiField("apple_care_email")
	private String appleCareEmail;

	/**
	 * appleCareMPN
	 */
	@ApiField("apple_care_mpn")
	private String appleCareMpn;

	/**
	 * 卖家昵称
	 */
	@ApiField("buyer_nick")
	private String buyerNick;

	/**
	 * 套餐购对应的成分品id
	 */
	@ApiField("combine_sub_item_id")
	private Long combineSubItemId;

	/**
	 * 套餐购对应的成分品的skuId
	 */
	@ApiField("combine_sub_item_sku_id")
	private Long combineSubItemSkuId;

	/**
	 * 套餐购服务原价  (单位分) 
	 */
	@ApiField("comm_amount_unit")
	private String commAmountUnit;

	/**
	 * 车牌号
	 */
	@ApiField("et_plate_number")
	private String etPlateNumber;

	/**
	 * 天猫汽车预约服务时间
	 */
	@ApiField("et_ser_time")
	private String etSerTime;

	/**
	 * 电子凭证预约门店地址
	 */
	@ApiField("et_shop_name")
	private String etShopName;

	/**
	 * 电子凭证核销门店地址
	 */
	@ApiField("et_verified_shop_name")
	private String etVerifiedShopName;

	/**
	 * 服务订单与实物订单关联关系
	 */
	@ApiField("ext_service_biz_id")
	private String extServiceBizId;

	/**
	 * 服务所属的交易订单号。如果服务为一年包换，则item_oid这笔订单享受改服务的保护
	 */
	@ApiField("item_oid")
	private Long itemOid;

	/**
	 * 购买数量，取值范围为大于0的整数
	 */
	@ApiField("num")
	private Long num;

	/**
	 * 虚拟服务子订单订单号
	 */
	@ApiField("oid")
	private Long oid;

	/**
	 * 虚拟服务子订单订单号(String类型)
	 */
	@ApiField("oid_str")
	private String oidStr;

	/**
	 * 子订单实付金额。精确到2位小数，单位:元。如:200.07，表示:200元7分。
	 */
	@ApiField("payment")
	private String payment;

	/**
	 * 服务图片地址
	 */
	@ApiField("pic_path")
	private String picPath;

	/**
	 * 服务价格，精确到小数点后两位：单位:元
	 */
	@ApiField("price")
	private String price;

	/**
	 * 最近退款的id
	 */
	@ApiField("refund_id")
	private String refundId;

	/**
	 * 卖家昵称
	 */
	@ApiField("seller_nick")
	private String sellerNick;

	/**
	 * 服务详情的URL地址
	 */
	@ApiField("service_detail_url")
	private String serviceDetailUrl;

	/**
	 * 服务数字id
	 */
	@ApiField("service_id")
	private Long serviceId;

	/**
	 * 服务供应链-服务订单类型,1:主子挂载；2：双主挂载；3：单独售卖
	 */
	@ApiField("service_order_type")
	private String serviceOrderType;

	/**
	 * 服务供应链-服务商外部编码标
	 */
	@ApiField("service_outer_id")
	private String serviceOuterId;

	/**
	 * 商品名称
	 */
	@ApiField("title")
	private String title;

	/**
	 * 支持家装类物流的类型
	 */
	@ApiField("tmser_spu_code")
	private String tmserSpuCode;

	/**
	 * 服务子订单总费用
	 */
	@ApiField("total_fee")
	private String totalFee;


	public String getAppleCareEmail() {
		return this.appleCareEmail;
	}
	public void setAppleCareEmail(String appleCareEmail) {
		this.appleCareEmail = appleCareEmail;
	}

	public String getAppleCareMpn() {
		return this.appleCareMpn;
	}
	public void setAppleCareMpn(String appleCareMpn) {
		this.appleCareMpn = appleCareMpn;
	}

	public String getBuyerNick() {
		return this.buyerNick;
	}
	public void setBuyerNick(String buyerNick) {
		this.buyerNick = buyerNick;
	}

	public Long getCombineSubItemId() {
		return this.combineSubItemId;
	}
	public void setCombineSubItemId(Long combineSubItemId) {
		this.combineSubItemId = combineSubItemId;
	}

	public Long getCombineSubItemSkuId() {
		return this.combineSubItemSkuId;
	}
	public void setCombineSubItemSkuId(Long combineSubItemSkuId) {
		this.combineSubItemSkuId = combineSubItemSkuId;
	}

	public String getCommAmountUnit() {
		return this.commAmountUnit;
	}
	public void setCommAmountUnit(String commAmountUnit) {
		this.commAmountUnit = commAmountUnit;
	}

	public String getEtPlateNumber() {
		return this.etPlateNumber;
	}
	public void setEtPlateNumber(String etPlateNumber) {
		this.etPlateNumber = etPlateNumber;
	}

	public String getEtSerTime() {
		return this.etSerTime;
	}
	public void setEtSerTime(String etSerTime) {
		this.etSerTime = etSerTime;
	}

	public String getEtShopName() {
		return this.etShopName;
	}
	public void setEtShopName(String etShopName) {
		this.etShopName = etShopName;
	}

	public String getEtVerifiedShopName() {
		return this.etVerifiedShopName;
	}
	public void setEtVerifiedShopName(String etVerifiedShopName) {
		this.etVerifiedShopName = etVerifiedShopName;
	}

	public String getExtServiceBizId() {
		return this.extServiceBizId;
	}
	public void setExtServiceBizId(String extServiceBizId) {
		this.extServiceBizId = extServiceBizId;
	}

	public Long getItemOid() {
		return this.itemOid;
	}
	public void setItemOid(Long itemOid) {
		this.itemOid = itemOid;
	}

	public Long getNum() {
		return this.num;
	}
	public void setNum(Long num) {
		this.num = num;
	}

	public Long getOid() {
		return this.oid;
	}
	public void setOid(Long oid) {
		this.oid = oid;
	}

	public String getOidStr() {
		return this.oidStr;
	}
	public void setOidStr(String oidStr) {
		this.oidStr = oidStr;
	}

	public String getPayment() {
		return this.payment;
	}
	public void setPayment(String payment) {
		this.payment = payment;
	}

	public String getPicPath() {
		return this.picPath;
	}
	public void setPicPath(String picPath) {
		this.picPath = picPath;
	}

	public String getPrice() {
		return this.price;
	}
	public void setPrice(String price) {
		this.price = price;
	}

	public String getRefundId() {
		return this.refundId;
	}
	public void setRefundId(String refundId) {
		this.refundId = refundId;
	}

	public String getSellerNick() {
		return this.sellerNick;
	}
	public void setSellerNick(String sellerNick) {
		this.sellerNick = sellerNick;
	}

	public String getServiceDetailUrl() {
		return this.serviceDetailUrl;
	}
	public void setServiceDetailUrl(String serviceDetailUrl) {
		this.serviceDetailUrl = serviceDetailUrl;
	}

	public Long getServiceId() {
		return this.serviceId;
	}
	public void setServiceId(Long serviceId) {
		this.serviceId = serviceId;
	}

	public String getServiceOrderType() {
		return this.serviceOrderType;
	}
	public void setServiceOrderType(String serviceOrderType) {
		this.serviceOrderType = serviceOrderType;
	}

	public String getServiceOuterId() {
		return this.serviceOuterId;
	}
	public void setServiceOuterId(String serviceOuterId) {
		this.serviceOuterId = serviceOuterId;
	}

	public String getTitle() {
		return this.title;
	}
	public void setTitle(String title) {
		this.title = title;
	}

	public String getTmserSpuCode() {
		return this.tmserSpuCode;
	}
	public void setTmserSpuCode(String tmserSpuCode) {
		this.tmserSpuCode = tmserSpuCode;
	}

	public String getTotalFee() {
		return this.totalFee;
	}
	public void setTotalFee(String totalFee) {
		this.totalFee = totalFee;
	}

}
