package com.taobao.api.internal.tmc;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import java.util.Date;
import java.util.concurrent.atomic.AtomicBoolean;

/**
 * TMC性能监视器
 * 性能测试时用，一般不开
 */
public class PerfMon {
    private static final Log LOG = LogFactory.getLog(PerfMon.class);

    private final AtomicBoolean enabled = new AtomicBoolean(false);

    public void enable() {
        enabled.set(true);
    }

    public void disable() {
        enabled.set(false);
    }

    protected void beforeSubmitMsgToQueue(Message message) {
        try {
            if(!enabled.get()) {
                return;
            }

            Date outgoingTime = message.getOutgoingTime();
            if(outgoingTime == null) {
                return;
            }

            long curTime = System.currentTimeMillis();
            long rt = curTime - outgoingTime.getTime();
            // 输出从tmc发出消息到sdk收到消息经历的时间
            LOG.info(String.format("%d,%d", curTime, rt));
        } catch (Throwable e) {
            LOG.error("beforeSubmitMsgToQueue err", e);
        }
    }
}
